/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.reg;

import javax.swing.JLabel;
import jcm.core.interacob;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.gui.gen.processdialog;
import jcm.gui.nav.showpan;
import jcm.gui.plot.mapplot;
import jcm.mod.cli.glotemp;
import jcm.mod.reg.mapdata;
import jcm.mod.reg.regseacli;

public class regcli
extends module
implements Runnable {
    public String[] datasets = new String[]{"had3_A2_80", "had3_A2_50", "had3_A2_20", "hhgsax80", "hhgsax20", "eegga180", "gggsa150", "jjgsa180", "basehad3", "baseline", "both1", "both2", "ratio1", "ratio2"};
    public String[] quantities = new String[]{"tmp", "tmn", "tmx", "dtr", "pre", "cld", "vap", "wnd", "rad", "slp", "hum", "mix&tmx&tmn&pre", "mix&experimental"};
    public String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    public param dataset = new param(new Object[]{"dataset", this.datasets, "had3_A2_80"}){

        public void precalc() {
            regcli.this.checkdoublerequest();
        }
    };
    public param quantity = new param(new Object[]{"quantity", this.quantities, "tmp"}){

        public void precalc() {
            regcli.this.checkdoublerequest();
        }
    };
    public param month = new param("month", this.months, "jan");
    public param scale = new param("scaletojcm", false);
    public param scaleyear = new param("regcliyear", "yr", 2100, 1750, 2300);
    String oldqd = "";
    public static boolean gotdata = false;
    public static boolean ready = false;
    boolean both;
    boolean ratio;
    boolean hadbase;
    public mapdata d1 = new mapdata();
    public mapdata d2 = new mapdata();
    public mapdata d3 = new mapdata();
    public mapdata d4 = new mapdata();
    public mapdata d5 = new mapdata();
    public mapdata d6 = new mapdata();
    public double dataav;
    public int om = -1;
    public int[] land;

    public void setinteractions() {
        this.setaffectedby((interacob)this.get(glotemp.class), this.scale.istrue());
    }

    void checkdoublerequest() {
        if (!this.oldqd.equals(this.dataset.chosenname() + this.quantity.chosenname())) {
            this.oldqd = this.dataset.chosenname() + this.quantity.chosenname();
            gotdata = false;
        }
    }

    public void initsetup() {
        this.makeland();
        this.om = -1;
        this.addAction(showpan.pan("Map", mapplot.class, this));
        super.initsetup();
    }

    public void postcalc() {
        ready = false;
        if (!gotdata) {
            processdialog processdialog2 = new processdialog(this, "Loading GCM Data", new JLabel("<html>Loading GCM Data<p>please wait..."));
        } else {
            this.calc();
        }
    }

    public void run() {
        this.getdata();
        this.om = -1;
        this.calc();
        this.changed = true;
        loop.go();
    }

    public void calc() {
        if (this.om != this.month.getchosenindex()) {
            this.om = this.month.getchosenindex();
        }
        if (this.quantity.chosenname().startsWith("mix")) {
            if (this.both || this.ratio) {
                this.d1.restore(this.om);
                this.d2.restore(this.om);
                this.d3.restore(this.om);
                this.d4.restore(this.om);
                this.d5.restore(this.om);
                this.d6.restore(this.om);
                if (this.scale.istrue()) {
                    this.d4.scaledata((double)this.modelav() / this.dataav);
                    this.d5.scaledata((double)this.modelav() / this.dataav);
                    this.d6.scaledata((double)this.modelav() / this.dataav);
                }
                this.combine(this.d1, this.d1, this.d4);
                this.combine(this.d2, this.d2, this.d5);
                this.combine(this.d3, this.d3, this.d6);
            } else {
                this.d1.restore(this.om);
                this.d2.restore(this.om);
                this.d3.restore(this.om);
                if (this.scale.istrue() && !this.dataset.chosenname().startsWith("base")) {
                    this.d1.scaledata((double)this.modelav() / this.dataav);
                    this.d2.scaledata((double)this.modelav() / this.dataav);
                    this.d3.scaledata((double)this.modelav() / this.dataav);
                }
            }
            if (this.quantity.chosen == "mix&experimental") {
                this.mix(this.d1, this.d1, this.d2);
            }
        } else if (this.both || this.ratio) {
            this.d2.restore(this.om);
            this.d1.restore(this.om);
            if (this.scale.istrue()) {
                this.d2.scaledata((double)this.modelav() / this.dataav);
            }
            if (!this.get(regseacli.class).ratioafterregion.istrue()) {
                this.combine(this.d1, this.d1, this.d2);
            }
        } else {
            this.d1.restore(this.om);
            if (this.scale.istrue() && !this.dataset.chosenname().startsWith("base")) {
                this.d1.scaledata((double)this.modelav() / this.dataav);
            }
        }
        ready = true;
    }

    public void combine(mapdata dest, mapdata d1, mapdata d2) {
        for (int i = 0; i < d1.nlat; ++i) {
            for (int j = 0; j < d1.nlon; ++j) {
                int k = i * d1.nlon + j;
                int k2 = (int)((double)i * ((double)d2.nlat / (double)d1.nlat)) * d2.nlon + (int)((double)j * ((double)d2.nlon / (double)d1.nlon));
                if (d1.r[k] <= -999.0f || d2.r[k2] <= -999.0f) {
                    dest.r[k] = -999.0f;
                    continue;
                }
                dest.r[k] = this.ratio ? (d1.r[k] != 0.0f ? d2.r[k2] / d1.r[k] : -999.0f) : d2.r[k2] + d1.r[k];
            }
        }
    }

    public void getdata() {
        this.both = this.dataset.chosenname().startsWith("both");
        this.ratio = this.dataset.chosenname().startsWith("ratio");
        this.hadbase = this.dataset.chosenname().endsWith("1");
        gotdata = false;
        if (this.quantity.chosenname().startsWith("mix")) {
            if (this.both || this.ratio) {
                if (this.hadbase) {
                    this.d1.getdata("basehad3", "tmx");
                    this.d2.getdata("basehad3", "pre");
                    this.d3.getdata("basehad3", "tmn");
                } else {
                    this.d1.getdata("baseline", "tmx");
                    this.d2.getdata("baseline", "pre");
                    this.d3.getdata("baseline", "tmn");
                }
                this.d4.getdata("had3_A2_80", "tmx");
                this.d5.getdata("had3_A2_80", "pre");
                this.d6.getdata("had3_A2_80", "tmn");
            } else {
                this.d1.getdata(this.dataset.chosenname(), "tmx");
                this.d2.getdata(this.dataset.chosenname(), "pre");
                this.d3.getdata(this.dataset.chosenname(), "tmn");
            }
        } else if (this.both || this.ratio) {
            this.d1.getdata(this.hadbase ? "basehad3" : "baseline", this.quantity.chosenname());
            this.d2.getdata("had3_A2_80", this.quantity.chosenname());
        } else {
            this.d1.getdata(this.dataset.chosenname(), this.quantity.chosenname());
        }
        if (this.quantity.chosenname() == "tmp") {
            if (this.both || this.ratio) {
                this.dataav = this.d2.av;
            } else if (this.dataset.chosen != "baseline") {
                this.dataav = this.d1.av;
            }
        }
        gotdata = true;
    }

    public float modelav() {
        return this.get(glotemp.class).avchange.get((int)this.scaleyear.val) - this.get(glotemp.class).avchange.get(1975);
    }

    public float tempbase() {
        return this.get(glotemp.class).avchange.a[(int)this.get(glotemp.class).baseyear.getval() - 1750] - this.get(glotemp.class).avchange.a[0];
    }

    void makeland() {
        int[] hadoc = new int[]{363, 4, 5, 6, 78, 20, 31, 2, 43, 4, 2, 13, 29, 7, 41, 3, 6, 10, 24, 1, 2, 13, 28, 4, 4, 5, 6, 9, 11, 3, 9, 25, 11, 3, 6, 6, 2, 7, 4, 8, 10, 7, 3, 37, 2, 22, 2, 2, 3, 6, 12, 2, 1, 41, 5, 21, 3, 2, 4, 3, 5, 2, 5, 3, 1, 42, 5, 19, 6, 1, 4, 2, 13, 3, 2, 35, 2, 1, 8, 18, 5, 2, 22, 1, 2, 31, 5, 1, 16, 12, 4, 4, 15, 1, 3, 1, 2, 31, 5, 2, 17, 13, 2, 5, 14, 2, 1, 36, 4, 1, 19, 13, 1, 6, 12, 40, 25, 19, 14, 13, 2, 23, 25, 10, 1, 5, 2, 1, 14, 8, 3, 2, 1, 23, 1, 1, 24, 10, 2, 4, 17, 1, 2, 1, 1, 3, 3, 2, 1, 22, 2, 1, 24, 15, 16, 3, 5, 8, 1, 20, 3, 1, 24, 14, 17, 2, 8, 6, 1, 17, 2, 1, 2, 1, 26, 12, 18, 5, 7, 22, 4, 2, 26, 12, 19, 5, 6, 23, 32, 10, 19, 15, 1, 19, 33, 9, 19, 15, 2, 18, 34, 4, 22, 19, 2, 14, 36, 3, 22, 13, 1, 5, 3, 12, 37, 3, 4, 1, 16, 14, 1, 5, 4, 3, 2, 4, 39, 3, 1, 1, 3, 2, 14, 15, 1, 3, 5, 3, 3, 3, 40, 4, 19, 15, 1, 2, 6, 2, 5, 3, 2, 1, 39, 2, 18, 17, 8, 1, 5, 3, 3, 1, 39, 1, 18, 18, 7, 1, 5, 2, 4, 1, 40, 1, 1, 4, 13, 17, 19, 1, 41, 6, 12, 3, 2, 11, 14, 1, 3, 1, 44, 6, 12, 2, 3, 10, 14, 1, 2, 2, 44, 7, 16, 9, 15, 1, 2, 2, 43, 8, 16, 8, 16, 2, 1, 3, 4, 1, 37, 10, 15, 7, 17, 1, 8, 2, 36, 12, 13, 7, 27, 2, 35, 12, 13, 7, 65, 11, 13, 7, 25, 1, 39, 10, 14, 7, 2, 1, 20, 3, 1, 1, 37, 10, 14, 7, 2, 1, 19, 6, 38, 9, 14, 6, 3, 1, 19, 7, 38, 8, 14, 6, 2, 1, 18, 10, 37, 7, 15, 6, 2, 1, 18, 10, 37, 6, 17, 4, 22, 10, 37, 6, 17, 4, 22, 10, 36, 6, 18, 3, 23, 3, 2, 5, 36, 6, 50, 4, 36, 5, 52, 2, 37, 4, 62, 1, 29, 3, 62, 1, 30, 2, 62, 1, 31, 2, 94, 2, 94, 1, 95, 1, 96, 1, 384, 1, 29, 3, 7, 16, 39, 2, 24, 35, 34, 3, 16, 45, 32, 3, 13, 48, 15, 20, 10, 53, 4, 29, 8, 54, 5, 94, 5, 330};
        this.land = new int[7008];
        int k = 0;
        int l = -1;
        for (int i = 0; i < hadoc.length; ++i) {
            for (int j = 0; j < hadoc[i]; ++j) {
                this.land[k] = l;
                ++k;
            }
            l = -l;
        }
    }

    public void mix(mapdata dest, mapdata d1, mapdata d2) {
        for (int i = 0; i < d1.nlat; ++i) {
            for (int j = 0; j < d1.nlon; ++j) {
                int k = i * d1.nlon + j;
                dest.r[k] = 16 * (4 * ((double)d1.r[k] < d1.av - 0.5 * d1.sd ? 0 : ((double)d1.r[k] < d1.av ? 1 : ((double)d1.r[k] < d1.av + 0.5 * d1.sd ? 2 : 3))) + ((double)d2.r[k] < d2.av - 0.5 * d2.sd ? 0 : ((double)d2.r[k] < d2.av ? 1 : ((double)d2.r[k] < d2.av + 0.5 * d2.sd ? 2 : 3))));
            }
        }
    }
}

