/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.ogas;

import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.data.interpolator;
import jcm.mod.data.sres;
import jcm.mod.obj.controller;
import jcm.mod.obj.futbasescen;
import jcm.mod.ogas.fgas;
import jcm.mod.reg.region;
import jcm.mod.soc.socreg;

public class othgasemit
extends module {
    String[] emitoptions = new String[]{"sresfix", "sresscale", "2000fix", "2000scale"};
    public param emitoption = new param("othgasemitoptions", this.emitoptions, "sresscale");
    public qt ch4emit = new qt("ch4", colfont.green);
    public qt n2oemit = new qt("n2o", colfont.brown);
    public qt soxemit = new qt("sox", colfont.blue);
    public qt coemit = new qt("co", colfont.dkgrey);
    public qt vocemit = new qt("voc", colfont.yellowgreen);
    public qt noxemit = new qt("nox", colfont.orange);
    public qtset conc = new qtset(this.ch4emit, this.n2oemit, this.soxemit, this.coemit, this.vocemit, this.noxemit, "othgasemitcurves", "tera&gram&per&yr");
    float scale;
    float[] scgas = new float[6];
    float[][][] scgasdata = new float[][][]{sres.soxemit, sres.ch4emit, sres.n2oemit, sres.coemit, sres.vocemit, sres.noxemit};

    public void setinteractions() {
        this.follows(this.get(futbasescen.class), this.emitoption.chosen == "sresfix" || this.emitoption.chosen == "sresscale");
        this.follows(this.get(controller.class), this.emitoption.chosen == "sresscale" && this.get(controller.class).objective.chosen != "nopolicy" || this.emitoption.chosen == "2000scale");
    }

    public void initsetup() {
        int i = 0;
        while (i < 251) {
            int n = i++;
            this.ch4emit.a[n] = this.ch4emit.a[n] * 0.85f;
        }
        for (int j = 0; j < 110; ++j) {
            this.ch4emit.a[j] = this.ch4emit.a[110] * (float)j / 110.0f;
        }
        i = 0;
        while (i < 241) {
            int n = i++;
            this.soxemit.a[n] = this.soxemit.a[n] * (70.9f / this.soxemit.a[240]);
        }
        for (i = 241; i < 251; ++i) {
            this.soxemit.a[i] = ((float)(i - 240) * 69.0f + (float)(250 - i) * this.soxemit.a[240]) / 10.0f;
        }
        this.histnoxvoc();
        super.initsetup();
    }

    public void precalc() {
        this.scaleis92a();
    }

    public void calcstep() {
        if (year >= 2000) {
            this.scalesresemit();
        }
        if (((region)this.get(socreg.class).regions.chosen).name.equals("EDGAR") && year == 1890) {
            float emit1890 = this.get(socreg.class).emitn2o.calctot();
            for (int n = 0; n <= 140; ++n) {
                this.n2oemit.a[n] = emit1890 * ((float)n / 140.0f);
            }
        }
    }

    void scaleis92a() {
        for (int i = 0; i < 6; ++i) {
            this.scgas[i] = this.get(futbasescen.class).scenario.getchosenindex() == 6 ? this.scgasdata[i][0][0] / this.scgasdata[i][6][0] : 1.0f;
        }
    }

    void scalesresemit() {
        int yearb;
        this.scale = 1.0f;
        int sc = this.get(futbasescen.class).scenario.getchosenindex();
        if (year > 2000 && this.emitoption.chosen == "sresscale") {
            this.scale = this.get(carboncycle.class).fossil.a[ns] / (1000.0f * sres.interp(sres.fosemit, sc, year));
        }
        if (year > 2000 && this.emitoption.chosen == "2000scale") {
            this.scale = this.get(carboncycle.class).fossil.a[ns] / this.get(carboncycle.class).fossil.a[250];
        }
        int year1 = this.emitoption.chosen == "2000fix" || this.emitoption.chosen == "2000scale" ? 2000 : year;
        this.soxemit.a[othgasemit.ns] = sres.interp(sres.soxemit, sc, year1) * this.scale * this.scgas[0];
        this.ch4emit.a[othgasemit.ns] = sres.interp(sres.ch4emit, sc, year1) * this.scale;
        this.n2oemit.a[othgasemit.ns] = sres.interp(sres.n2oemit, sc, year1) * this.scale * this.scgas[2];
        this.coemit.a[othgasemit.ns] = sres.interp(sres.coemit, sc, year1) * this.scale * this.scgas[3];
        this.vocemit.a[othgasemit.ns] = sres.interp(sres.vocemit, sc, year1) * this.scale * this.scgas[4];
        this.noxemit.a[othgasemit.ns] = sres.interp(sres.noxemit, sc, year1) * this.scale * this.scgas[5];
        int schfc = sc < 3 ? 0 : (sc < 7 ? sc - 2 : 2);
        int yeara = ns + 1750 + 5;
        int n = yearb = this.emitoption.chosen == "sresfix" || this.emitoption.chosen == "sresscale" ? yeara : 2000;
        if (yeara % 5 == 0 && yeara > 1930 && yeara <= 2400) {
            for (int g = 0; g < 12; ++g) {
                this.get(fgas.class).fgemit[g].a[yeara / 5 - 386] = sc == 6 && (g < 4 || g > 6) ? 0.0f : interpolator.interphfc(sres.hfcemit, g, schfc, yearb) * this.scale;
            }
        }
    }

    void histnoxvoc() {
        this.noxemit.a[250] = sres.interp(sres.noxemit, 0, 2000);
        this.vocemit.a[250] = sres.interp(sres.vocemit, 0, 2000);
        for (int ns = 0; ns < 250; ++ns) {
            this.noxemit.a[ns] = this.noxemit.a[250] * this.coemit.a[ns] / this.coemit.a[250];
            this.vocemit.a[ns] = this.vocemit.a[250] * this.coemit.a[ns] / this.coemit.a[250];
        }
    }
}

