/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.ogas;

import jcm.core.complexity;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.data.matchdata;
import jcm.mod.ogas.othgasemit;

public class aerosol
extends module {
    public param sulfrf2000 = new param("sulfrf2000", "w&per&m2", -1.2, -2.4, 0, colfont.cyan);
    public param solarrf2000 = new param("solarrf2000", "w&per&m2", 0.3, 0, 0.6, colfont.orange);
    public param volcfac = new param(new Object[]{"volcfac", "", -1.5, -3.0, 0, colfont.dkorange, complexity.expert});
    public param bcocwig = new param(new Object[]{"bcocwig", false, complexity.expert});
    public param hadleyaero = new param(new Object[]{"HadA", false, complexity.experimental});
    public param futuresolar = new param(new Object[]{"futsolopt", false, complexity.experimental});
    public param solardata = new param("solardata", new String[]{"Lean", "Hoyt&Schatten", "none"}, "Lean");
    public param incvolc = new param("incvolc", true);
    public qt aerorf = new qt(new Object[]{"totaerosol", colfont.cyan, complexity.simplest, qt.Type.total});
    public qt sulfdirrf = new qt("sulfdir", colfont.blue);
    public qt sulfindrf = new qt("sulfind", colfont.ltblue);
    public qt bcrf = new qt("blackcarbon", colfont.dkgrey);
    public qt ocrf = new qt("orgcarbon", colfont.ltgrey);
    public qt natvrf = new qt(new Object[]{"totnatvar", colfont.orange, complexity.simplest, qt.Type.total});
    public qt solarrf = new qt("solvar", colfont.yellow);
    public qt volcanorf = new qt("volcano", colfont.dkorange);
    public qtset aerosol = new qtset(this.aerorf, this.sulfdirrf, this.sulfindrf, this.bcrf, this.ocrf, this.natvrf, this.solarrf, this.volcanorf, "aerosolrf", "w&per&m2");
    boolean firsttime = true;
    double se2000 = 69.0;
    double senat = 42.0;
    double sdqdir2000 = -0.4;
    double sdqind2000 = -0.8;
    public static final float[] solarrfdata = new float[254];
    public static final float[] volcorig = new float[254];
    public double[] leanSolar = new double[]{1366.2868, 1366.0362, 1365.9468, 1365.8269, 1365.679, 1365.5999, 1365.573, 1365.6547, 1365.7453, 1365.8192, 1365.7565, 1365.857, 1365.7772, 1365.7036, 1365.6824, 1365.5719, 1365.5847, 1365.8602, 1366.1301, 1366.3445, 1366.3838, 1366.3062, 1366.2242, 1366.0195, 1365.976, 1365.8232, 1365.8978, 1366.0672, 1366.4796, 1366.4437, 1366.2016, 1366.331, 1366.0422, 1365.957, 1365.8415, 1365.9636, 1366.4103, 1366.6607, 1366.6225, 1366.5939, 1366.4756, 1366.2624, 1366.2194, 1366.0312, 1365.9765, 1365.783, 1365.6801, 1365.5353, 1365.4136, 1365.3227, 1365.3017, 1365.5357, 1365.3426, 1365.068, 1365.026, 1364.9907, 1364.8004, 1364.709, 1364.6664, 1364.623, 1364.595, 1364.5864, 1364.6153, 1364.6402, 1364.6487, 1364.6964, 1364.8557, 1364.8572, 1364.8376, 1364.8506, 1364.8128, 1364.8119, 1364.8462, 1364.8818, 1364.9686, 1365.1047, 1365.2742, 1365.4579, 1365.631, 1365.7284, 1365.8503, 1365.761, 1365.7187, 1365.6883, 1365.8063, 1366.1567, 1366.624, 1366.7331, 1366.549, 1366.4847, 1366.3706, 1366.1989, 1366.1174, 1366.0053, 1365.9915, 1366.0787, 1366.1284, 1366.2352, 1366.4086, 1366.383, 1366.1222, 1366.1305, 1366.0579, 1365.9297, 1365.7667, 1365.665, 1365.661, 1365.794, 1366.0168, 1366.3193, 1366.3914, 1366.2743, 1366.1073, 1366.0474, 1366.0001, 1365.8863, 1365.8231, 1365.7582, 1365.9292, 1366.1888, 1366.476, 1366.3867, 1366.316, 1366.0624, 1365.884, 1365.6433, 1365.599, 1365.5752, 1365.4549, 1365.4544, 1365.5734, 1365.746, 1365.6472, 1365.5213, 1365.6045, 1365.5679, 1365.4443, 1365.4098, 1365.3943, 1365.436, 1365.4713, 1365.6953, 1365.9115, 1365.9316, 1365.9647, 1365.9514, 1365.8818, 1365.646, 1365.6906, 1365.6201, 1365.5619, 1365.4493, 1365.4087, 1365.5463, 1365.6971, 1365.5142, 1365.6523, 1365.5702, 1365.6274, 1365.5968, 1365.5139, 1365.4962, 1365.5497, 1365.6208, 1365.7056, 1366.0476, 1366.2342, 1366.4705, 1366.4392, 1366.2164, 1366.1059, 1366.0237, 1365.9178, 1365.9088, 1365.9033, 1365.9759, 1366.0011, 1366.1698, 1366.074, 1365.9751, 1366.0317, 1365.9969, 1365.9665, 1365.9631, 1366.0975, 1366.3026, 1366.7184, 1366.7072, 1366.7317, 1366.7241, 1366.7949, 1366.7592, 1366.6771, 1366.5566, 1366.6024, 1366.8141, 1366.8834, 1367.2546, 1367.4923, 1367.359, 1367.1998, 1367.0516, 1366.9825, 1366.8958, 1366.8778, 1367.1282, 1367.6656, 1367.9917, 1367.8818, 1367.5702, 1367.6231, 1367.334, 1367.1234, 1367.0128, 1366.834, 1366.7924, 1366.9315, 1367.0203, 1367.0933, 1367.0899, 1366.9377, 1366.7375, 1366.8318, 1366.6555, 1366.6838, 1366.5701, 1366.5808, 1366.8432, 1367.4533, 1368.0713, 1368.1172, 1367.9037, 1367.579, 1367.4649, 1367.1799, 1367.0409, 1367.001, 1367.2029, 1367.8157, 1368.2017, 1368.1651, 1367.9996, 1367.7051, 1367.4, 1367.1455};
    float scf = 0.57119864f;
    float ecf = 1.3962634f;
    double volcdecay = 2.0;

    public void initsetup() {
        super.initsetup();
        this.follows(othgasemit.class);
        int i = 0;
        while (i < 251) {
            int n = i++;
            solarrfdata[n] = solarrfdata[n] * 1.5f;
        }
        i = 0;
        while (i < 251) {
            int n = i++;
            volcorig[n] = volcorig[n] * -0.1f;
        }
    }

    public void calcstep() {
        this.bcocrf(ns);
        this.sulfrf(ns);
        if (this.firsttime || this.solarrf2000.changed || this.solardata.changed || this.futuresolar.changed) {
            this.solarrf();
        }
        if (this.firsttime || this.volcfac.changed || this.incvolc.changed) {
            this.volcrf();
        }
        this.aerorf.a[jcm.mod.ogas.aerosol.ns] = this.sulfdirrf.a[ns] + this.sulfindrf.a[ns] + this.bcrf.a[ns] + this.ocrf.a[ns];
        this.natvrf.a[jcm.mod.ogas.aerosol.ns] = this.solarrf.a[ns] + (ns < 253 ? this.volcanorf.a[ns] : 0.0f);
    }

    public void postcalc() {
        this.firsttime = false;
    }

    void sulfrf(int ns) {
        if (this.hadleyaero.istrue()) {
            int hai = ns < 110 ? 0 : (ns < 350 ? ns - 110 : 240);
            this.sulfdirrf.a[ns] = (float)matchdata.hadleyaerosol[hai][0];
            this.sulfindrf.a[ns] = (float)matchdata.hadleyaerosol[hai][1];
        } else {
            this.sulfdirrf.a[ns] = (float)(this.sulfrf2000.getval() / (this.sdqdir2000 + this.sdqind2000) * (this.sdqdir2000 * (double)this.get(othgasemit.class).soxemit.a[ns] / this.se2000));
            this.sulfindrf.a[ns] = (float)(this.sulfrf2000.getval() / (this.sdqdir2000 + this.sdqind2000) * (this.sdqind2000 * (Math.log(1.0 + (double)this.get(othgasemit.class).soxemit.a[ns] / this.senat) / Math.log(1.0 + this.se2000 / this.senat))));
        }
    }

    void bcocrf(int ns) {
        if (this.bcocwig.istrue()) {
            float ff = this.get(othgasemit.class).soxemit.a[ns] / this.get(othgasemit.class).soxemit.a[240];
            float bb = (this.grossdefor(ns) > 0.0f ? this.grossdefor(ns) : 0.0f) / this.grossdefor(240);
            this.bcrf.a[ns] = 0.2f * ff + 0.2f * bb;
            this.ocrf.a[ns] = -0.1f * ff - 0.4f * bb;
        } else {
            this.bcrf.a[ns] = 0.4f * (this.get(othgasemit.class).coemit.a[ns] + 1036.0f - this.get(othgasemit.class).coemit.a[250]) / 1036.0f;
            this.ocrf.a[ns] = -0.5f * (this.get(othgasemit.class).coemit.a[ns] + 1036.0f - this.get(othgasemit.class).coemit.a[250]) / 1036.0f;
        }
        if (this.hadleyaero.istrue()) {
            this.bcrf.a[ns] = 0.0f;
            this.ocrf.a[ns] = 0.0f;
        }
        int n = ns;
        this.bcrf.a[n] = (float)((double)this.bcrf.a[n] * (this.sulfrf2000.getval() / (double)-1.2f));
        int n2 = ns;
        this.ocrf.a[n2] = (float)((double)this.ocrf.a[n2] * (this.sulfrf2000.getval() / (double)-1.2f));
    }

    float grossdefor(int ns) {
        return this.get(carboncycle.class).lucf.a[ns] + 5.0f * (float)(ns > 100 ? (ns < 350 ? ns - 100 : 250) : 0);
    }

    void solarrf() {
        this.solarrf.a[jcm.mod.ogas.aerosol.ns] = this.solardata.chosen.equals("none") ? 0.0f : (float)(this.solarrf2000.getval() / 0.3) * (float)(year < 2000 ? (this.solardata.chosen.equals("Lean") && year < 1995 ? (this.leanSolar[year - 1750] - 1366.3) / 4.0 : (double)solarrfdata[ns]) : (double)0.3f + (this.futuresolar.istrue() ? (double)0.06f * Math.sin(this.scf * (float)(year - 2000)) : 0.0));
    }

    void volcrf() {
        if (ns < 254) {
            this.volcanorf.a[jcm.mod.ogas.aerosol.ns] = this.incvolc.istrue() ? (float)(-this.volcfac.getval() * (double)volcorig[ns] * (1.0 - Math.exp(-this.volcdecay)) / this.volcdecay + (ns > 0 ? (double)this.volcanorf.a[ns - 1] * Math.exp(-this.volcdecay) : 0.0)) : 0.0f;
        }
    }
}

