/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.obj;

import jcm.core.complexity;
import jcm.core.interacob;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.sealevel;
import jcm.mod.cli.udebclimod;
import jcm.mod.data.sres;
import jcm.mod.math.mathcurve;
import jcm.mod.obj.controller;
import jcm.mod.obj.futbasescen;
import jcm.mod.obj.stabtempfuzzy;
import jcm.mod.soc.history;
import jcm.mod.soc.shares;

public class stabilisation
extends module
implements Runnable {
    String[] indicators = new String[]{"stabemit", "stabconc", "stabrf&allghg", "stabrf&allghgaero", "stabtemp", "stabsea", "constant", "stfuzzy"};
    String[] concscenname = new String[]{"400ppm", "450ppm", "500ppm", "550ppm", "600ppm", "650ppm", "750ppm", "850ppm", "1000ppm", "user"};
    int[] concscenlevel = new int[]{400, 450, 500, 550, 600, 650, 750, 850, 1000};
    public param indicator = new param(new Object[]{"indicator", this.indicators, "stabconc"}){

        public void precalc() {
            if (this.chosen == "reduceintensity") {
                stabilisation.this.get(shares.class).kyotop.flag = false;
            }
            stabilisation.this.resetguess();
        }
    };
    public param concscenmenu = new param(new Object[]{"stabconcmenu", this.concscenname, "user"}){

        public void precalc() {
            if (this.chosen != "user") {
                stabilisation.this.stabconclevel.setval(stabilisation.this.concscenlevel[this.getchosenindex()]);
                stabilisation.this.stabyear.setval(2100.0 + (double)(stabilisation.this.concscenlevel[this.getchosenindex()] - 450) / 2.0);
            }
        }
    };
    public param stabyear = new param("stabyear", "", 2125, 2030, 2380);
    public param stabconclevel = new param("stabconc&atlevel", "ppm", 500, 300, 1000, this.stabyear);
    public param stabconcinitslope = new param(new Object[]{"stabconcinitslope", "ppm&per&year&squared", 0.02, -0.1, 0.1, complexity.expert});
    public param stabrflevel = new param("stabrf&atlevel", "w&per&m2", 3.1, 1.5, 8.0, this.stabyear);
    public param stabtemplevel = new param("stabtemp&atlevel", "degcbase", 2.0, 1.0, 7.0, this.stabyear);
    public param wre = new param("wreopt", false);
    public param stabconcstartyear = new param(new Object[]{"stabconcstartyear", "", 2003, 1990, 2050, complexity.expert});
    public param stabemityear = new param("stabemityear", "", 2080, 2010, 2380);
    public param stabemitlevel = new param("stabemit&atlevel", "mega&ton&carbon&per&yr", 2000, 0, 12000, this.stabemityear);
    public param sygrowth = new param(new Object[]{"initgrow", "percent&per&yr", 1.5, -3.5, 3.5, complexity.expert});
    public param quartic = new param(new Object[]{"integralopt", false, complexity.expert});
    public param integralgt = new param(new Object[]{"integral", "giga&ton&carbon", 500, 150, 2000, complexity.expert});
    public param stabseayear = new param(new Object[]{"stabseayear", "", 2250, 2030, 2380, complexity.expert});
    public param stabsealevel = new param(new Object[]{"stabsea&atlevel", "metres", 0.75, 0.5, 3.0, this.stabseayear, complexity.expert});
    public param damp = new param(new Object[]{"dampopt", false, complexity.expert});
    public float[] target = new float[652];
    float[] curvetocheck;
    public int x0;
    public int sy = 2003;
    float y0;
    float dy0;
    float d2y0;
    double targetlevel = 0.0;
    double co2stab = 0.0;
    double co2staborig = 0.0;
    double stabcor = 1.0;
    double oldstabcor = 1.0;
    double co2stabslope = 0.0;
    double co2stabslopeorig = 0.0;
    double stabslopecor = 1.0;
    double oldstabslopecor = 0.0;
    double co2end = 0.0;
    double co2endorig = 0.0;
    double endcor = 1.0;
    double oldendcor = 1.0;
    double olditw = 3.4028234663852886E38;
    double oldco2stab;
    int sys;
    int scy;
    public boolean goodenough = false;
    public boolean running = false;
    public int stit = 0;

    public void setinteractions() {
        this.follows(history.class);
        this.setaffectedby((interacob)this.get(controller.class).objective);
        this.setaffectedby((interacob)this.get(carboncycle.class), this.indicator.chosen == "stabconc");
        this.setaffectedby((interacob)this.get(radfor.class), this.indicator.chosen == "stabrf&allghgaero" || this.indicator.chosen == "stabrf&allghg");
        this.setaffectedby((interacob)this.get(glotemp.class), this.indicator.chosen == "stabtemp");
        this.setaffectedby((interacob)this.get(glotemp.class).baseyear, this.indicator.chosen == "stabtemp");
        this.setaffectedby((interacob)this.get(sealevel.class), this.indicator.chosen == "stabsea");
        this.setaffectedby((interacob)this.get(stabtempfuzzy.class), this.indicator.chosen == "stfuzzy");
        this.setaffects((interacob)this.get(stabtempfuzzy.class), this.indicator.chosen == "stfuzzy");
        this.affectsfutureonly = true;
        this.setaffectedby((interacob)this.stabyear, this.indicator.chosen == "stabconc" || this.indicator.chosen == "stabrf&allghg" || this.indicator.chosen == "stabrf&allghgaero" || this.indicator.chosen == "stabtemp" || this.indicator.chosen == "stfuzzy");
        this.setaffectedby((interacob)this.stabconcinitslope, this.indicator.chosen == "stabconc" || this.indicator.chosen == "stabrf&allghg" || this.indicator.chosen == "stabrf&allghgaero" || this.indicator.chosen == "stabtemp");
        this.setaffectedby((interacob)this.stabconclevel, this.indicator.chosen == "stabconc");
        this.setaffectedby((interacob)this.concscenmenu, this.indicator.chosen == "stabconc");
        this.setaffectedby((interacob)this.stabrflevel, this.indicator.chosen == "stabrf&allghgaero" || this.indicator.chosen == "stabrf&allghg");
        this.setaffectedby((interacob)this.stabtemplevel, this.indicator.chosen == "stabtemp" || this.indicator.chosen == "stfuzzy");
        this.setaffectedby((interacob)this.wre, this.indicator.chosen != "constant");
        this.setaffectedby((interacob)this.stabconcstartyear, this.wre.istrue());
        this.setaffectedby((interacob)this.stabemityear, this.indicator.chosen == "stabemit");
        this.setaffectedby((interacob)this.stabemitlevel, this.indicator.chosen == "stabemit");
        this.setaffectedby((interacob)this.sygrowth, this.indicator.chosen == "stabemit");
        this.setaffectedby((interacob)this.quartic, this.indicator.chosen == "stabemit");
        this.setaffectedby((interacob)this.integralgt, this.indicator.chosen == "stabemit" && this.quartic.istrue());
        this.setaffectedby((interacob)this.stabseayear, this.indicator.chosen == "stabsea");
        this.setaffectedby((interacob)this.stabsealevel, this.indicator.chosen == "stabsea");
        this.setaffectedby((interacob)this.damp, this.indicator.chosen == "stfuzzy");
    }

    public void precalc() {
        if (!this.running) {
            this.setstartyear();
        }
    }

    public void calcstep() {
        carboncycle carboncycle2 = this.get(carboncycle.class);
        if (year == this.sy) {
            if (this.indicator.chosen == "stabemit") {
                this.emittarget((int)this.stabemityear.getval(), this.stabemitlevel.getval());
            }
            if (this.indicator.chosen == "stabconc") {
                this.conctarget((int)this.stabyear.getval(), this.stabconclevel.getval());
            }
            if (this.indicator.chosen == "stabtemp" || this.indicator.chosen == "stabrf&allghgaero" || this.indicator.chosen == "stabrf&allghg" || this.indicator.chosen == "stabsea") {
                this.setlevel();
                if (!this.running) {
                    this.initialguess();
                    new Thread(this).start();
                }
                this.conctarget(this.scy, this.co2stab, this.co2stabslope, this.co2end);
            }
        }
        if (this.indicator.chosen == "stfuzzy") {
            this.get(stabtempfuzzy.class).calcstep();
        }
        if (year >= this.sy) {
            if (this.indicator.chosen == "stabemit") {
                carboncycle2.totemit.set(year, this.target[year - 1750]);
            } else if (this.indicator.chosenname().startsWith("stab")) {
                carboncycle2.totemit.set(year, carboncycle2.inverseco2(this.target[ns], 1));
            }
            if (this.indicator.chosen == "constant") {
                carboncycle2.totemit.set(year, carboncycle2.totemit.get(year - 1));
            }
        }
    }

    public void postcalc() {
        if (this.indicator.chosen == "stabrf&allghgaero" || this.indicator.chosen == "stabrf&allghg" || this.indicator.chosen == "stabtemp" || this.indicator.chosen == "stabsea") {
            this.applycorrection();
        }
    }

    void setstartyear() {
        int n = this.sy = this.get(shares.class).kyotop.istrue() ? 2013 : 2003;
        if (this.wre.istrue() && !this.get(shares.class).kyotop.istrue()) {
            this.delaystart();
        }
    }

    void delaystart() {
        if (this.wre.changed) {
            this.stabconcstartyear.setval(2002 + (int)((this.stabconclevel.getval() - 350.0) / 23.0));
        }
        int dsy = (int)this.stabconcstartyear.getval();
        int oldsc = this.get(futbasescen.class).scenario.getchosenindex();
        this.get(futbasescen.class).scenario.choose(6);
        for (int year = this.sy; year <= dsy; ++year) {
            this.get(carboncycle.class).fossil.a[year - 1750] = 1000.0f * sres.interp(sres.fosemit, this.get(futbasescen.class).scenario.getchosenindex(), year) * 0.9436619f;
        }
        this.get(futbasescen.class).scenario.choose(oldsc);
        this.sy = dsy;
    }

    float[] gradient(qt q, int x0) {
        int x0s = x0 - 1750;
        float y = q.a[x0s];
        float d2y = x0s < 260 ? (float)this.stabconcinitslope.getval() : y - 2.0f * q.a[x0s - 1] + q.a[x0s - 2];
        float dy = 2.5f * d2y + (q.a[x0s] - q.a[x0s - 5]) / 5.0f;
        return new float[]{y, dy, d2y};
    }

    void emittarget(int xs, double ys) {
        double y0 = this.get(carboncycle.class).totemit.get(this.sy);
        double dy0 = y0 * this.sygrowth.getval() / 100.0;
        if (this.quartic.istrue()) {
            mathcurve.quarticend(this.target, this.sy, xs, y0, dy0, ys, 0.0, this.integralgt.getval() * 1000.0);
        } else {
            mathcurve.cubicend(this.target, this.sy, xs, y0, dy0, ys, 0.0);
        }
        for (int x = xs; x <= 2400; ++x) {
            float f = (float)ys;
            this.target[x - 1750] = f;
            this.target[x - 1750] = f;
        }
    }

    void conctarget(int xs, double ys) {
        this.conctarget(xs, ys, 0.0, ys);
    }

    void conctarget(int xs, double ys, double dys, double ye) {
        float[] gr = this.gradient(this.get(carboncycle.class).co2atppm, this.sy - 1);
        mathcurve.padequintic(this.target, this.sy - 1, xs, gr[0], gr[1], gr[2], ys, dys, 0.0);
        if (xs < 2400) {
            if (dys == 0.0 || 2400 - xs < 20) {
                for (int x = xs; x <= 2400; ++x) {
                    this.target[x - 1750] = (float)ye;
                }
            } else {
                mathcurve.flatquadratic(this.target, xs, 2400, ys, dys, ye);
            }
        }
    }

    void setlevel() {
        if (this.indicator.chosen == "stabrf&allghgaero" || this.indicator.chosen == "stabrf&allghg") {
            this.curvetocheck = this.indicator.chosen == "stabrf&allghgaero" ? this.get(radfor.class).anthrorf.a : this.get(radfor.class).ghgrf.a;
            this.targetlevel = this.stabrflevel.getval();
            this.setstabconcyear(this.stabyear.getval());
        }
        if (this.indicator.chosen == "stabtemp") {
            this.curvetocheck = this.get(glotemp.class).avchange.a;
            this.targetlevel = this.stabtemplevel.getval() + this.get(glotemp.class).offset;
            this.setstabconcyear(this.stabyear.getval());
        }
        if (this.indicator.chosen == "stabsea") {
            this.curvetocheck = this.get(sealevel.class).total.a;
            this.targetlevel = this.stabsealevel.getval();
            this.setstabconcyear(this.stabseayear.getval());
        }
    }

    void setstabconcyear(double stabconcyear) {
        this.sys = (int)stabconcyear - 1750;
        this.scy = 2003 + (int)(1.0 * (stabconcyear - 2003.0));
    }

    void initialguess() {
        if (this.indicator.chosen == "stabrf&allghgaero" || this.indicator.chosen == "stabrf&allghg") {
            this.guessconcfromrf(this.targetlevel * (double)this.get(radfor.class).totalrf.a[this.sys] / (double)(this.indicator.chosen == "stabrf&allghgaero" ? this.get(radfor.class).anthrorf.a[this.sys] : this.get(radfor.class).ghgrf.a[this.sys]));
        }
        if (this.indicator.chosen == "stabtemp") {
            this.guessconcfromrf(this.guessrffromtemp(this.targetlevel));
        }
        if (this.indicator.chosen == "stabsea") {
            this.guessconcfromrf(this.guessrffromtemp(this.guesstempfromsealevel(this.targetlevel)));
        }
    }

    double guesstempfromsealevel(double sealeveltarget) {
        return this.get(sealevel.class).total.a[this.sys] > 0.0f ? (double)this.get(glotemp.class).avchange.a[this.sys] * sealeveltarget / (double)this.get(sealevel.class).total.a[this.sys] : 2.0;
    }

    double guessrffromtemp(double stabtemplevel) {
        return stabtemplevel * (this.get(glotemp.class).avchange.a[this.sys] > 0.0f ? (double)(this.get(radfor.class).totalrf.a[this.sys] / this.get(glotemp.class).avchange.a[this.sys]) : this.get(udebclimod.class).rfco2double.getval() / this.get(udebclimod.class).climsens.getval());
    }

    void guessconcfromrf(double guesstotrf) {
        double co2rf = guesstotrf * (this.get(radfor.class).totalrf.a[this.sys] > 0.0f ? (double)(this.get(carboncycle.class).co2rf.a[this.sys] / this.get(radfor.class).totalrf.a[this.sys]) : 0.85);
        this.get(carboncycle.class);
        this.co2staborig = 278.0 * Math.exp(Math.log(2.0) * co2rf / this.get(udebclimod.class).rfco2double.getval());
        this.co2stab = this.co2staborig * this.oldstabcor;
        this.co2stabslopeorig = 0.0;
        this.co2stabslope = this.oldstabslopecor;
        this.co2endorig = this.co2stab;
        this.co2end = this.co2endorig * this.oldendcor;
    }

    void applycorrection() {
        this.stabcor = this.targetlevel / (double)this.curvetocheck[this.sys];
        this.stabslopecor = -0.05 * (double)(this.curvetocheck[this.sys + 10] - this.curvetocheck[this.sys - 10]) / (double)this.curvetocheck[this.sys - 1];
        this.endcor = this.curvetocheck[this.sys] / this.curvetocheck[649];
        this.co2stab = 278.0 + (this.co2stab - 278.0) * this.stabcor;
        if (this.co2stab < 300.0) {
            this.co2stab = 300.0;
        }
        if (this.stit <= 6 || this.stabslopecor / this.oldstabslopecor < 1.0) {
            this.co2stabslope += this.stabslopecor * (this.co2stab - 278.0);
        }
        this.co2end = 278.0 + (this.co2end - 278.0) * this.endcor;
        if (this.co2end < 300.0) {
            this.co2end = 300.0;
        }
        boolean impossible = Double.isInfinite(this.co2stab) || Double.isInfinite(this.co2end) || Double.isNaN(this.co2stab) || Double.isNaN(this.co2end) || this.co2stab < 300.0 || this.co2end < 300.0;
        this.goodenough = impossible || this.stabcor < 1.01 && this.stabcor > 0.99 && this.stabslopecor < 0.01 && this.stabslopecor > -0.01 && this.endcor < 1.01 && this.endcor > 0.99;
        ++this.stit;
        this.savecorrect();
    }

    void savecorrect() {
        this.oldstabcor = this.co2stab / this.co2staborig;
        this.oldstabslopecor = (this.co2stabslope - this.co2stabslopeorig) / (this.co2stab - 278.0);
        this.oldendcor = this.co2end / this.co2endorig;
    }

    void resetcorrect() {
        this.oldstabcor = 1.0;
        this.oldstabslopecor = 0.0;
        this.oldendcor = 1.0;
    }

    void resetguess() {
        this.resetcorrect();
        this.goodenough = false;
    }

    public void run() {
        this.running = true;
        System.out.println("Stabilisation iteratation starting");
        Thread.currentThread();
        Thread.yield();
        try {
            while (loop.inmainloop) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            System.out.println("stab loop interrupted");
        }
        while (!this.goodenough && this.stit < 20) {
            this.changed = true;
            loop.changeinteractions = false;
            loop.go();
        }
        System.out.println("Stabilisation iteratated " + this.stit + " times");
        this.stit = 0;
        this.running = false;
    }
}

