/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.obj;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import jcm.core.interacob;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.gui.gen.processdialog;
import jcm.mod.carbon.carboncycle;
import jcm.mod.math.mathcurve;
import jcm.mod.math.optimiser;
import jcm.mod.obj.controller;
import jcm.mod.obj.stabilisation;
import jcm.mod.soc.costs;
import jcm.mod.soc.socreg;

public class optimisation
extends module
implements optimiser.optimcaller,
Runnable {
    public float[] target = new float[652];
    public param optvariant = new param("optvariant", ov.getlist(), "concstablev");
    public optimiser optim;
    int x0 = 2002;
    float y0 = 1.0f;
    float dy0 = 1.0f;
    float d2y0 = 1.0f;
    JLabel pinfo = new JLabel("initialising...");
    JCheckBox pcb = new JCheckBox("Running", true);
    processdialog pd;

    ov getov() {
        for (ov v : ov.values()) {
            if (!v.name().equals(this.optvariant.chosen)) continue;
            return v;
        }
        return null;
    }

    public float getobjfunc() {
        return this.get(costs.class).itw;
    }

    public void setinteractions() {
        this.setaffectedby((interacob)this.get(controller.class).objective);
        this.setaffectedby((interacob)this.get(costs.class));
    }

    void setstart(ov ov2) {
        switch (ov2) {
            case emitcubics: 
            case emitlinear: 
            case emitquartic: {
                this.y0 = this.get(carboncycle.class).fossil.a[this.x0 - 1750];
                this.dy0 = (this.y0 - this.get(carboncycle.class).fossil.a[this.x0 - 10 - 1750]) / 10.0f;
                break;
            }
            case reduceemitquad: 
            case reduceemitlin: {
                this.y0 = 1.0f;
                break;
            }
            default: {
                float[] gr = this.get(stabilisation.class).gradient(this.get(carboncycle.class).co2atppm, this.x0);
                this.y0 = gr[0];
                this.dy0 = gr[1];
                this.d2y0 = gr[2];
            }
        }
    }

    void settarget(ov ov2, float[] target, float[] par) {
        float ys = ov2 == ov.concstablev || par.length < 2 ? par[0] : par[1];
        int xs = (int)(2000.0f + (ov2 == ov.concstablev ? 0.5f : par[0]) * (ys - 250.0f));
        switch (ov2) {
            case emitcubics: 
            case conccubics: {
                mathcurve.setofcubics(target, new int[]{this.x0, 2100, 2200, 2300}, new float[]{this.y0, par[0], par[2], par[4]}, new float[]{this.dy0, par[1], par[3], par[5]});
                break;
            }
            case emitlinear: 
            case reduceemitlin: {
                mathcurve.setoflinear(target, new int[]{this.x0, 2025, 2050, 2075, 2100, 2150, 2200, 2250, 2300, 2350, 2400}, new float[]{this.y0, par[0], par[1], par[2], par[3], par[4], par[5], par[6], par[7], par[8], par[9]});
                break;
            }
            case emitquartic: {
                mathcurve.padequartic(target, this.x0, 2150, this.y0, this.dy0, par[0], par[1], par[2]);
                break;
            }
            case reduceemitquad: {
                mathcurve.flatquadratic(target, this.x0, 2400, this.y0, -par[0], par[1]);
                break;
            }
            case concstablev: 
            case concstablevyr4: {
                mathcurve.padequartic(target, this.x0, xs, this.y0, this.dy0, this.d2y0, ys, 0.0);
                for (int x = xs; x <= 2400; ++x) {
                    target[x - 1750] = ys;
                }
                break;
            }
            case concstablevyr5: {
                mathcurve.padequintic(target, this.x0, xs, this.y0, this.dy0, this.d2y0, ys, 0.0, 0.0);
                for (int x = xs; x <= 2400; ++x) {
                    target[x - 1750] = ys;
                }
                break;
            }
            case concquartic: {
                mathcurve.padequartic(target, this.x0, xs, this.y0, this.dy0, this.d2y0, ys, par[2]);
                break;
            }
            case concquintic: {
                mathcurve.padequintic(target, this.x0, xs, this.y0, this.dy0, this.d2y0, ys, par[2], par[3]);
                break;
            }
            case concquincub: {
                mathcurve.padequintic(target, this.x0, xs, this.y0, this.dy0, this.d2y0, ys, par[2], par[3]);
                mathcurve.simplecubic(target, xs, 2400, ys, par[2], par[3], par[4]);
                break;
            }
            case concquarquad: {
                mathcurve.padequintic(target, this.x0, xs, this.y0, this.dy0, this.d2y0, ys, par[2], 0.0);
                mathcurve.flatquadratic(target, xs, 2400, ys, par[2], par[3]);
                break;
            }
            case concquarquar: {
                float d2ys = mathcurve.padequartic(target, this.x0, xs, this.y0, this.dy0, this.d2y0, ys, par[2]);
                mathcurve.padequartic(target, xs, 2400, ys, par[2], d2ys, par[3], par[4]);
            }
        }
    }

    void applytarget(ov ov2, float[] target) {
        switch (ov2) {
            case emitcubics: 
            case emitlinear: 
            case emitquartic: {
                this.get(carboncycle.class).fossil.a[optimisation.ns] = target[ns];
                break;
            }
            case reduceemitquad: 
            case reduceemitlin: {
                this.get(carboncycle.class).fossil.a[optimisation.ns] = target[ns] * this.get(socreg.class).emitfosbase.calctot();
                break;
            }
            default: {
                this.get(carboncycle.class).totemit.a[optimisation.ns] = this.get(carboncycle.class).inverseco2(target[ns]);
            }
        }
    }

    public void precalc() {
        if (this.pd == null || !this.pd.running) {
            if (this.optvariant.changed || this.optim == null) {
                ov v = this.getov();
                this.optim = new optimiser(this, v.initguess, v.perturb, v.min, v.max);
                this.setstart(v);
            }
            this.optvariant.changed = false;
            this.pd = new processdialog(this, "Optimisation", new JLabel("<html><i>iterative optimisation"), this.pinfo, this.pcb);
        }
    }

    public void calcstep() {
        if (this.pd != null && Thread.currentThread() == this.pd.mythread && year > 2003) {
            this.applytarget(this.getov(), this.target);
        }
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (!this.optim.goodenough && this.pcb.isSelected()) {
            Thread.currentThread();
            Thread.yield();
            try {
                while (loop.inmainloop) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                System.out.println("opt loop interrupted");
            }
            float[] par = this.optim.nextpoint();
            this.pinfo.setText(this.optim.report);
            this.settarget(this.getov(), this.target, par);
            this.changed = true;
            loop.changeinteractions = false;
            loop.go();
        }
        this.pcb.setSelected(true);
        this.optim.reset();
        System.out.println("Optimisation finished");
        this.get(costs.class).reportcosts();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ov {
        emitcubics(new float[]{5000.0f, 30.0f, 3000.0f, 20.0f, 1000.0f, 10.0f}, new float[]{2500.0f, 15.0f, 1500.0f, 10.0f, 1500.0f, 10.0f}, new float[]{0.0f, -50.0f, 0.0f, -50.0f, 0.0f, -50.0f}, new float[]{30000.0f, 150.0f, 30000.0f, 150.0f, 30000.0f, 150.0f}),
        emitlinear(new float[]{6000.0f, 6000.0f, 5000.0f, 4000.0f, 3000.0f, 2000.0f, 1000.0f, 500.0f, 500.0f, 500.0f}, new float[]{1000.0f, 1500.0f, 2000.0f, 2000.0f, 1500.0f, 1000.0f, 1000.0f, 1000.0f, 1000.0f, 1000.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, new float[]{30000.0f, 30000.0f, 30000.0f, 30000.0f, 30000.0f, 30000.0f, 30000.0f, 30000.0f, 3000.0f, 3000.0f}),
        emitquartic(new float[]{0.0f, 2000.0f, 0.0f}, new float[]{2.0f, 1000.0f, 10.0f}, new float[]{-10.0f, 0.0f, -50.0f}, new float[]{10.0f, 20000.0f, 50.0f}),
        reduceemitquad(new float[]{0.02f, 0.3f}, new float[]{0.001f, 0.1f}, new float[]{0.0f, 0.0f}, new float[]{1.0f, 1.0f}),
        reduceemitlin(new float[]{0.8f, 0.7f, 0.6f, 0.5f, 0.4f, 0.3f, 0.2f, 0.1f, 0.1f, 0.1f}, new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.05f, 0.05f, 0.05f, 0.05f, 0.05f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f}),
        concstablev(new float[]{500.0f}, new float[]{50.0f}, new float[]{350.0f}, new float[]{3000.0f}),
        concstablevyr4(new float[]{0.5f, 500.0f}, new float[]{0.1f, 50.0f}, new float[]{0.25f, 350.0f}, new float[]{0.75f, 3000.0f}),
        concstablevyr5(new float[]{0.5f, 500.0f}, new float[]{0.1f, 50.0f}, new float[]{0.25f, 350.0f}, new float[]{0.75f, 3000.0f}),
        concquartic(new float[]{0.5f, 500.0f, 0.0f}, new float[]{0.1f, 50.0f, 0.1f}, new float[]{0.25f, 350.0f, -0.5f}, new float[]{0.75f, 3000.0f, 1.0f}),
        concquintic(new float[]{0.5f, 500.0f, 0.0f, 0.0f}, new float[]{0.1f, 50.0f, 0.1f, 0.01f}, new float[]{0.25f, 350.0f, -0.5f, -0.05f}, new float[]{0.75f, 3000.0f, 1.0f, 0.1f}),
        conccubics(new float[]{500.0f, 0.0f, 500.0f, 0.0f, 500.0f, 0.0f}, new float[]{50.0f, 0.1f, 50.0f, 0.1f, 50.0f, 0.1f}, new float[]{350.0f, -0.5f, 375.0f, -0.5f, 375.0f, -0.5f}, new float[]{3000.0f, 1.0f, 3000.0f, 1.0f, 3000.0f, 1.0f}),
        concquincub(new float[]{0.5f, 500.0f, 0.0f, 0.0f, 500.0f}, new float[]{0.1f, 50.0f, 0.1f, 0.01f, 50.0f}, new float[]{0.25f, 350.0f, -0.5f, -0.05f, 375.0f}, new float[]{0.75f, 3000.0f, 1.0f, 0.1f, 3000.0f}),
        concquarquad(new float[]{0.5f, 500.0f, 0.0f, 500.0f}, new float[]{0.1f, 50.0f, 0.1f, 50.0f}, new float[]{0.25f, 375.0f, -0.5f, 350.0f}, new float[]{0.75f, 3000.0f, 1.0f, 3000.0f}),
        concquarquar(new float[]{0.5f, 500.0f, 0.0f, 450.0f, 0.0f}, new float[]{0.1f, 50.0f, 0.1f, 50.0f, 0.1f}, new float[]{0.25f, 350.0f, -0.5f, 375.0f, -0.5f}, new float[]{0.75f, 3000.0f, 1.0f, 3000.0f, 1.0f});

        float[] initguess;
        float[] perturb;
        float[] min;
        float[] max;

        static String[] getlist() {
            String[] list = new String[ov.values().length];
            int n = 0;
            for (ov v : ov.values()) {
                list[n] = v.name();
                ++n;
            }
            return list;
        }

        private ov(float[] a, float[] b, float[] c, float[] d) {
            this.initguess = a;
            this.perturb = b;
            this.min = c;
            this.max = d;
        }
    }
}

