/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.math;

public class optimiser {
    int nd;
    int np;
    int cp;
    int ni;
    int ni2;
    float[][] sx;
    float[] cen;
    float[] hip;
    float[] lop;
    float[] rfp;
    float[] newp;
    float[] initguess;
    float[] perturb;
    float[] max;
    float[] min;
    float of;
    float tol;
    float tol2;
    float nsd;
    optimcaller oc;
    public String report;
    public int step = 0;
    static int reset = 0;
    static int fill = 1;
    static int reflect = 2;
    static int compare = 3;
    static int checkcontract = 4;
    static int checkexpand = 5;
    static int checkopt = 6;
    static String[] stepname = new String[]{"reset", "fill", "reflect", "compare", "chkcon", "chkexp", "chkopt"};
    public boolean goodenough = false;
    public boolean oktocheckvar = false;
    public static boolean showreport = true;

    public optimiser(optimcaller oc, float[] initguess, float[] perturb, float[] min, float[] max) {
        this.oc = oc;
        this.initguess = initguess;
        this.perturb = perturb;
        this.max = max;
        this.min = min;
        this.nd = initguess.length;
        this.np = this.nd + 1;
        this.step = reset;
        this.tol = 1.0E-4f;
        this.tol2 = 0.05f;
        this.sx = new float[this.np][this.np];
        this.rfp = new float[this.np];
        this.newp = new float[this.np];
        this.cen = new float[this.nd];
    }

    public void reset() {
        this.ni = 0;
        this.ni2 = 0;
        this.step = reset;
        this.initguess = this.cen;
        this.goodenough = false;
    }

    public float[] nextpoint() {
        if (this.step == reset) {
            this.cp = 0;
            this.init(this.initguess, 1.0f);
            this.step = fill;
            this.nsd = -999.0f;
        } else {
            this.getobjfunc();
        }
        if (showreport || this.ni % 50 == 0) {
            this.report();
        }
        ++this.ni;
        if (this.step == fill) {
            if (this.cp < this.np) {
                this.newp = this.sx[this.cp];
                ++this.cp;
                return this.newp;
            }
            this.step = reflect;
        }
        if (this.step == checkopt) {
            if (this.cp < this.np) {
                this.newp = this.sx[this.cp];
                ++this.cp;
                return this.newp;
            }
            this.findhighlow();
            if (this.lop == this.sx[0]) {
                this.goodenough = true;
                this.report = this.report + " end-opt ";
                this.report();
                return this.lop;
            }
            this.ni2 = 0;
            this.step = reflect;
        }
        if (this.step == checkexpand) {
            if (this.of < this.rfp[this.nd]) {
                this.copy(this.newp, this.sx[this.cp]);
            } else {
                this.copy(this.rfp, this.sx[this.cp]);
            }
            this.step = reflect;
        }
        if (this.step == checkcontract) {
            if (this.of < this.rfp[this.nd]) {
                this.copy(this.newp, this.sx[this.cp]);
                this.step = reflect;
            } else {
                this.cp = 0;
                this.totalcon();
                this.step = fill;
                this.oktocheckvar = true;
                return this.nextpoint();
            }
        }
        if (this.step == compare) {
            this.copy(this.newp, this.rfp);
            if (this.of < this.lop[this.nd]) {
                this.expcon(2.0f);
                this.step = checkexpand;
                return this.newp;
            }
            if (this.of >= this.hip[this.nd]) {
                this.copy(this.hip, this.rfp);
                this.expcon(-0.5f);
                this.step = checkcontract;
                this.oktocheckvar = true;
                return this.newp;
            }
            if (this.sechigh()) {
                this.expcon(0.5f);
                this.step = checkcontract;
                return this.newp;
            }
            this.copy(this.newp, this.sx[this.cp]);
            this.step = reflect;
        }
        if (this.step == reflect) {
            if (this.oktocheckvar) {
                this.oktocheckvar = false;
                if (this.checkvar()) {
                    this.findhighlow();
                    this.cp = 0;
                    this.init(this.lop, this.tol2);
                    this.step = checkopt;
                    return this.nextpoint();
                }
                ++this.ni2;
                this.step = reflect;
            }
            this.findhighlow();
            this.findcentre(true);
            this.expcon(1.0f);
            this.step = compare;
            return this.newp;
        }
        return null;
    }

    void copy(float[] a, float[] b) {
        for (int d = 0; d < this.np; ++d) {
            b[d] = a[d];
        }
    }

    void getobjfunc() {
        this.of = this.oc.getobjfunc();
        if (Float.isNaN(this.of)) {
            this.of = Float.MAX_VALUE;
        }
        for (int d = 0; d < this.nd; ++d) {
            if (!(this.newp[d] > this.max[d]) && !(this.newp[d] < this.min[d])) continue;
            this.of = Float.MAX_VALUE;
            this.report = this.report + "hit limits! ";
        }
        this.newp[this.nd] = this.of;
    }

    void report() {
        this.report = "it=" + this.ni + "\t " + stepname[this.step] + "\t ";
        for (int d = 0; d < this.nd + 1; ++d) {
            this.report = this.report + (float)((int)(this.newp[d] * 1000.0f)) / 1000.0f + "\t ";
        }
        System.out.println(this.report);
    }

    void findhighlow() {
        this.hip = this.sx[0];
        this.lop = this.sx[0];
        this.cp = 0;
        for (int p = 1; p < this.np; ++p) {
            if (this.sx[p][this.nd] > this.hip[this.nd]) {
                this.hip = this.sx[p];
                this.cp = p;
            }
            if (!(this.sx[p][this.nd] < this.lop[this.nd])) continue;
            this.lop = this.sx[p];
        }
    }

    boolean sechigh() {
        for (int p = 0; p < this.np; ++p) {
            if (!(this.sx[p][this.nd] > this.newp[this.nd]) || this.sx[p] == this.hip) continue;
            return false;
        }
        return true;
    }

    void findcentre(boolean exchigh) {
        int d;
        for (d = 0; d < this.nd; ++d) {
            this.cen[d] = 0.0f;
        }
        for (int p = 0; p < this.np; ++p) {
            if (exchigh && this.sx[p] == this.hip) continue;
            for (int d2 = 0; d2 < this.nd; ++d2) {
                int n = d2;
                this.cen[n] = this.cen[n] + this.sx[p][d2];
            }
        }
        for (d = 0; d < this.nd; ++d) {
            int n = d;
            this.cen[n] = this.cen[n] / (float)(exchigh ? this.np - 1 : this.np);
        }
    }

    void expcon(float fac) {
        this.newp = new float[this.np];
        for (int d = 0; d < this.nd; ++d) {
            this.newp[d] = (1.0f + fac) * this.cen[d] - fac * this.hip[d];
        }
    }

    void totalcon() {
        for (int p = 0; p < this.np; ++p) {
            for (int d = 0; d < this.nd; ++d) {
                this.sx[p][d] = (this.sx[p][d] + this.lop[d]) / 2.0f;
            }
        }
    }

    void init(float[] guess, float fac) {
        for (int p = 0; p < this.np; ++p) {
            for (int d = 0; d < this.nd; ++d) {
                this.sx[p][d] = guess[d] + (p == d + 1 ? this.perturb[d] * fac : 0.0f);
            }
        }
    }

    boolean checkvar() {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int p = 0; p < this.np; ++p) {
            sum += (double)this.sx[p][this.nd];
            sum2 += (double)(this.sx[p][this.nd] * this.sx[p][this.nd]);
        }
        double mean = sum / (double)this.np;
        double var = sum2 / (double)this.np - mean * mean;
        double sd = Math.pow(var, 0.5);
        this.nsd = (float)(sd / mean);
        if (Float.isNaN(this.nsd) && showreport) {
            System.out.println("optstatprob: " + mean + " " + sum + " " + sum2 + " " + var + " " + this.nsd);
        }
        return this.ni > 1000 || this.ni > this.np + 5 && this.nsd < this.tol && this.nsd > -this.tol;
    }

    public static interface optimcaller {
        public float getobjfunc();
    }
}

