/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jcm.core.complexity;
import jcm.core.interacob;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.udebclimod;

public class sealevel
extends module {
    double[] glsens = new double[]{0.12, 0.16, 0.09, 0.1, 0.03, 0.15, 0.14, 0.3};
    double[] ansens = new double[]{-0.18, -0.37, -0.35, -0.21, -0.48, -0.31, -0.48, -0.21};
    public param greenlandsens = new param("greenland-sensitivity", "", this.glsens[2], -0.5, 0.5, colfont.green);
    public param antarcticasens = new param("antarctica-sensitivity", "", this.ansens[2], -0.5, 0.5, colfont.cyan);
    public qt thermexp = new qt("thermexp", colfont.red);
    public qt glacier = new qt("glaciers", colfont.grey);
    public qt longterm = new qt("rfia", colfont.black);
    public qt antarctica = new qt("antarctica", colfont.cyan);
    public qt greenland = new qt("greenland", colfont.green);
    public qt freshwater = new qt(new Object[]{"freshwater", colfont.dkgreen, complexity.expert});
    public qt other = new qt("Other", colfont.brown);
    public qt total = new qt(new Object[]{"totsl", colfont.dkblue, complexity.simplest, qt.Type.total});
    public qtset sealevel = new qtset(this.thermexp, this.glacier, this.greenland, this.antarctica, this.longterm, this.freshwater, this.other, this.total, "sealevelrise", "metres");
    double totglac = 0.5;
    double taul = 70.0;
    double tauh = 130.0;
    double deltatl = 0.7;
    double deltath = 3.0;
    int ng = 10;
    int n;
    double eqglac;
    double[] glac = new double[this.ng];
    double[] glac99 = new double[this.ng];
    double[] tau = new double[this.ng];
    double[] deltat = new double[this.ng];

    public void seticecaptomod(int m) {
        this.greenlandsens.setval(this.glsens[m]);
        this.antarcticasens.setval(this.ansens[m]);
    }

    public void initsetup() {
        this.follows(this.get(glotemp.class));
        this.follows(this.get(udebclimod.class));
        this.greenlandsens.setaffectedby((interacob)this.get(udebclimod.class).climod);
        this.antarcticasens.setaffectedby((interacob)this.get(udebclimod.class).climod);
    }

    public void precalc() {
        this.glaciersetup();
    }

    public void calcstep() {
        if (ns > 0) {
            this.glaciermelt();
            this.polarmelt();
            this.longterm.a[jcm.mod.cli.sealevel.ns] = (float)((double)this.longterm.a[ns - 1] + 2.5E-4);
            this.other.a[jcm.mod.cli.sealevel.ns] = (float)((double)this.other.a[ns - 1] + (ns < 240 ? 5.0E-5 : 1.7E-4));
            this.freshwater.a[jcm.mod.cli.sealevel.ns] = 0.0f;
        }
        this.total.a[jcm.mod.cli.sealevel.ns] = this.thermexp.a[ns] + this.glacier.a[ns] + this.longterm.a[ns] + this.antarctica.a[ns] + this.greenland.a[ns] + this.freshwater.a[ns] + this.other.a[ns];
    }

    public void save99() {
        this.n = 0;
        while (this.n < this.ng) {
            this.glac99[this.n] = this.glac[this.n];
            ++this.n;
        }
    }

    public void startstate(int startyear) {
        this.longterm.a[0] = 0.0f;
        this.antarctica.a[0] = 0.0f;
        this.greenland.a[0] = 0.0f;
        this.freshwater.a[0] = 0.0f;
        this.glacier.a[0] = 0.0f;
        this.other.a[0] = 0.0f;
        if (startyear == 2000) {
            this.n = 0;
            while (this.n < this.ng) {
                this.glac[this.n] = this.glac99[this.n];
                ++this.n;
            }
        } else {
            this.n = 0;
            while (this.n < this.ng) {
                this.glac[this.n] = this.totglac / (double)this.ng;
                ++this.n;
            }
        }
    }

    void glaciersetup() {
        this.n = 0;
        while (this.n < this.ng) {
            this.tau[this.n] = this.taul + (this.tauh - this.taul) * (double)this.n / (double)(this.ng - 1);
            this.deltat[this.n] = this.deltatl + (this.deltath - this.deltatl) * (double)this.n / (double)(this.ng - 1);
            ++this.n;
        }
    }

    void glaciermelt() {
        this.glacier.a[jcm.mod.cli.sealevel.ns] = (float)this.totglac;
        this.n = 0;
        while (this.n < this.ng) {
            this.eqglac = this.totglac / (double)this.ng * (1.0 - (double)this.get(glotemp.class).avchange.a[ns] / this.deltat[this.n]);
            if (this.eqglac < 0.0) {
                this.eqglac = 0.0;
            }
            int n = this.n;
            this.glac[n] = this.glac[n] - 0.3 * (this.glac[this.n] - this.eqglac) / this.tau[this.n];
            int n2 = ns;
            this.glacier.a[n2] = (float)((double)this.glacier.a[n2] - this.glac[this.n]);
            ++this.n;
        }
    }

    void polarmelt() {
        double glsensfac = 1.0 + ((double)this.get(glotemp.class).avchange.a[ns] - 1.5) * 0.3;
        double ansensfac = (double)this.get(glotemp.class).avchange.a[ns] * 0.05;
        this.antarctica.a[jcm.mod.cli.sealevel.ns] = (float)((double)this.antarctica.a[ns - 1] + ((ns > 350 ? ansensfac : 0.0) + this.antarcticasens.getval()) * (double)this.get(glotemp.class).avchange.a[ns] * 0.001);
        this.greenland.a[jcm.mod.cli.sealevel.ns] = (float)((double)this.greenland.a[ns - 1] + (ns > 350 ? glsensfac : 1.0) * this.greenlandsens.getval() * (double)this.get(glotemp.class).avchange.a[ns] * 0.001);
    }
}

