/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.cli;

import jcm.core.complexity;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.udebclimod;
import jcm.mod.ogas.aerosol;
import jcm.mod.ogas.atchem;
import jcm.mod.ogas.fgas;

public class radfor
extends module {
    carboncycle carboncycle;
    atchem atchem;
    fgas fgas;
    aerosol aerosol;
    public param unifdist = new param(new Object[]{"unif", false, complexity.expert}){

        public void precalc() {
            radfor.this.distribute();
        }
    };
    public param only4gas = new param(new Object[]{"4gas", false, complexity.experimental});
    public float[][] splitrf = new float[4][652];
    public qt totalrf = new qt(new Object[]{"totrf", colfont.red, complexity.simplest, qt.Type.total});
    public qt anthrorf = new qt(new Object[]{"allghgaero", colfont.dkred, complexity.expert, qt.Type.total});
    public qt ghgrf = new qt(new Object[]{"allghg", colfont.greygreen, complexity.expert, qt.Type.total});
    public qt nlrf = new qt(new Object[]{this.splitrf[0], "rfnl", colfont.red, complexity.expert});
    public qt norf = new qt(new Object[]{this.splitrf[1], "rfno", colfont.blue, complexity.expert});
    public qt sorf = new qt(new Object[]{this.splitrf[2], "rfso", colfont.cyan, complexity.expert});
    public qt slrf = new qt(new Object[]{this.splitrf[3], "rfsl", colfont.orange, complexity.expert});
    public qtset allrf = new qtset(this.totalrf, this.anthrorf, this.ghgrf, "allrf", "w&per&m2");
    public qtset allrf2 = new qtset(this.totalrf, "allrf_detail", "w&per&m2");
    public qtset regrf = new qtset(this.totalrf, this.nlrf, this.norf, this.sorf, this.slrf, "regrf", "w&per&m2");
    double[] frac;
    double[] splitnls = new double[4];
    double[] splitnlw = new double[4];
    double[] splitl = new double[4];
    double[] splitsl = new double[4];
    double[] splits = new double[4];

    public void initsetup() {
        super.initsetup();
        this.carboncycle = this.get(carboncycle.class);
        this.atchem = this.get(atchem.class);
        this.aerosol = this.get(aerosol.class);
        this.fgas = this.get(fgas.class);
        this.follows(this.carboncycle);
        this.follows(this.atchem);
        this.follows(this.aerosol);
        this.follows(this.fgas);
        this.allrf.add(this.carboncycle.co2rf, this.atchem.othgasrf, this.fgas.fgasrf, this.aerosol.aerorf, this.aerosol.natvrf);
        this.allrf2.add(this.carboncycle.co2rf, this.atchem.ch4rf, this.atchem.n2orf, this.atchem.tropo3rf, this.atchem.strath2orf, this.fgas.cfcrf, this.fgas.hfcrf, this.fgas.strato3rf, this.aerosol.sulfdirrf, this.aerosol.sulfindrf, this.aerosol.bcrf, this.aerosol.ocrf, this.aerosol.solarrf, this.aerosol.volcanorf);
    }

    public void calcstep() {
        this.calctotals();
        this.calcsplit();
    }

    void distribute() {
        if (this.unifdist.istrue()) {
            for (int i = 0; i < 4; ++i) {
                this.splitnls[i] = 1.0;
                this.splitnlw[i] = 1.0;
                this.splitl[i] = 1.0;
                this.splitsl[i] = 1.0;
                this.splits[i] = 1.0;
            }
        } else {
            this.frac = this.get(udebclimod.class).frac;
            this.splitnls[0] = 0.6000000000000001 / (0.75 * this.frac[0] + 0.25 * this.frac[1]);
            this.splitnls[1] = this.splitnls[0] / 3.0;
            this.splitnls[3] = 0.15000000000000002 / (0.75 * this.frac[3] + 0.25 * this.frac[2]);
            this.splitnls[2] = this.splitnls[3] / 3.0;
            this.splitnlw[0] = 0.44448888999999997 / (0.6667 * this.frac[0] + 0.3333 * this.frac[1]);
            this.splitnlw[1] = this.splitnlw[0] / 2.0;
            this.splitnlw[3] = 0.22221111 / (0.6667 * this.frac[3] + 0.3333 * this.frac[2]);
            this.splitnlw[2] = this.splitnlw[3] / 2.0;
            this.splitl[0] = 0.6667 / this.frac[0];
            this.splitl[1] = 0.0;
            this.splitl[3] = 0.3333 / this.frac[3];
            this.splitl[2] = 0.0;
            this.splitsl[0] = 0.249975 / (0.75 * this.frac[0] + 0.25 * this.frac[1]);
            this.splitsl[1] = this.splitsl[0] / 3.0;
            this.splitsl[3] = 0.5000249999999999 / (0.75 * this.frac[3] + 0.25 * this.frac[2]);
            this.splitsl[2] = this.splitnls[3] / 3.0;
            this.splits[0] = 0.5;
            this.splits[1] = 0.5;
            this.splits[2] = 1.5;
            this.splits[3] = 1.5;
        }
    }

    void calcsplit() {
        for (int i = 0; i < 4; ++i) {
            this.splitrf[i][radfor.ns] = (float)((double)(this.carboncycle.co2rf.a[ns] + this.atchem.ch4rf.a[ns] + this.atchem.strath2orf.a[ns] + this.atchem.n2orf.a[ns] + this.fgas.cfcrf.a[ns] + this.fgas.hfcrf.a[ns] + this.aerosol.natvrf.a[ns]) + (double)(this.aerosol.sulfdirrf.a[ns] + this.aerosol.bcrf.a[ns] + this.aerosol.ocrf.a[ns]) * this.splitnls[i] + (double)(this.aerosol.sulfindrf.a[ns] + this.atchem.tropo3rf.a[ns]) * this.splitnlw[i] + (double)this.fgas.strato3rf.a[ns] * this.splits[i]);
        }
    }

    void calctotals() {
        if (this.get(radfor.class).only4gas.istrue()) {
            this.ghgrf.a[radfor.ns] = this.carboncycle.co2rf.a[ns] + this.atchem.ch4rf.a[ns] + this.atchem.n2orf.a[ns];
            this.anthrorf.a[radfor.ns] = this.ghgrf.a[ns] + this.aerosol.sulfdirrf.a[ns] + this.aerosol.sulfindrf.a[ns];
            this.totalrf.a[radfor.ns] = this.anthrorf.a[ns];
        } else {
            this.ghgrf.a[radfor.ns] = this.carboncycle.co2rf.a[ns] + this.atchem.othgasrf.a[ns] + this.fgas.fgasrf.a[ns];
            this.anthrorf.a[radfor.ns] = this.ghgrf.a[ns] + this.aerosol.aerorf.a[ns];
            this.totalrf.a[radfor.ns] = this.anthrorf.a[ns] + this.aerosol.natvrf.a[ns];
        }
    }
}

