/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.carbon;

import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.cli.glotemp;

public class carbonatechemistry
extends module {
    public qt pH = new qt("pH", colfont.dkgreen);
    public qt bicarbonate = new qt("HCO3-", colfont.blue);
    public qt carbonate = new qt("CO3(2-)", colfont.dkblue);
    public qt co2aq = new qt("CO2aq", colfont.cyan);
    public qt totc02 = new qt("TCO2", colfont.black);
    public qtset conc = new qtset(this.co2aq, this.bicarbonate, this.carbonate, this.totc02, "concentrations", "molar");
    public qtset pHset = new qtset(this.pH, "pH", "- log10 [H+]");
    String[] chemoptions = new String[]{"realb", "realj", "hildaz0z1", "cubicfit", "linear"};
    public param gasex = new param("asgasex", "mol&per&m2&per&ppm&per&yr", colfont.orange, 0.06, 0, 0.12);
    public param carbchem = new param("carbchemmenu", this.chemoptions, "realj");
    public param chemfeedback = new param("chemfbopt", true);
    double askodml;
    double talk;
    double totb;
    double[] oafdml;
    double[] askoaf;
    double[] alpha;
    double[] gamma;
    double[] cubfitf;
    double[] totc0;
    double[] calk;
    double[] hyd;
    double[] k1;
    double[] k2;
    double[] kb;
    double[] kw;
    double[] k0;
    double[] octemp;
    double[] saflin;
    double[] saflin0;
    double dml = 75.0;
    double ocarea = 3.616E14;
    double hfrac = 0.16;

    public void setinteractions() {
        this.setaffectedby(glotemp.class, this.chemfeedback.istrue());
    }

    public void setupchemistry() {
        double airseak = this.gasex.getval();
        this.askodml = 1000.0 * airseak / this.dml;
        this.oafdml = new double[2];
        this.oafdml[0] = 1.0E15 / (12.0 * this.ocarea * (1.0 - this.hfrac) * this.dml);
        this.oafdml[1] = 1.0E15 / (12.0 * this.ocarea * this.hfrac * this.dml);
        this.askoaf = new double[2];
        this.askoaf[0] = 1.2E-11 * airseak * this.ocarea * (1.0 - this.hfrac);
        this.askoaf[1] = 1.2E-11 * airseak * this.ocarea * this.hfrac;
        this.alpha = new double[2];
        this.alpha[0] = 4.71E-4 * this.askoaf[0];
        this.alpha[1] = 4.71E-4 * this.askoaf[1];
        this.hyd = new double[2];
        this.hyd[0] = 1.0E-8;
        this.hyd[1] = 1.0E-8;
        this.calk = new double[2];
        this.calk[0] = this.talk - 0.001;
        this.calk[1] = this.talk - 0.001;
        this.saflin = new double[2];
        this.saflin0 = new double[2];
        this.gamma = new double[2];
        this.cubfitf = new double[2];
        this.k0 = new double[2];
        this.k1 = new double[2];
        this.k2 = new double[2];
        this.kb = new double[2];
        this.kw = new double[2];
        this.octemp = new double[2];
        this.octemp[0] = 21.37;
        this.octemp[1] = 1.38;
        this.talk = 0.0024;
        this.totb = 4.16E-4;
        this.totc0 = new double[2];
        this.totc0[0] = this.totc0(this.octemp[0]);
        this.totc0[1] = this.totc0(this.octemp[1]);
        this.saflin[0] = this.saflin(this.octemp[0]);
        this.saflin[1] = this.saflin(this.octemp[1]);
        this.saflin0[0] = this.saflin[0];
        this.saflin0[1] = this.saflin[1];
        this.chemconsts(this.octemp[0], 0);
        this.chemconsts(this.octemp[1], 1);
    }

    void temperaturefeedback() {
        if (this.chemfeedback.istrue()) {
            double octr = this.get(glotemp.class).getoceantemprise();
            this.chemconsts(this.octemp[0] + octr, 0);
            this.chemconsts(this.octemp[1] + octr, 1);
        }
    }

    double z0(double t) {
        return 1.7561 - 0.031618 * t + 4.444E-4 * t * t;
    }

    double z1(double t) {
        return 0.004096 - 7.7086E-5 * t + 6.1E-7 * t * t;
    }

    double k0(double t) {
        return Math.exp(-60.2409 + 9345.17 / t + 23.3585 * Math.log(t / 100.0) + 35.0 * (0.023517 - 2.3656E-4 * t + 4.7036E-7 * t * t));
    }

    double kb(double t) {
        return Math.exp(-(28559.7 / t) + 1016.43 - 181.498 * Math.log(t) + 0.314173 * t);
    }

    double k1(double t) {
        return Math.exp(-(2331.08 / t) - 1.5529413 * Math.log(t) + 3.18181);
    }

    double k2(double t) {
        return Math.exp(-(3493.43 / t) - 0.2005743 * Math.log(t) - 7.69056);
    }

    double kw(double t) {
        return Math.exp(-(13145.2 / t) - 17.4432 * Math.log(t) + 113.0395);
    }

    double totc0(double t) {
        return 0.002221 - 9.5E-6 * t;
    }

    double saflin(double t) {
        return this.askodml * (1.68 - 0.036 * t + 6.0E-4 * t * t);
    }

    double cubfitf(double t) {
        return this.askodml * (80.0 - 3.5 * t + 0.05 * t * t) / 1000000.0;
    }

    void chemconsts(double t, int b) {
        if (this.carbchem.chosen == "hildaz0z1") {
            this.saflin[b] = this.z0(t) * this.askodml;
            this.gamma[b] = this.z1(t) * this.oafdml[b];
        }
        if (this.carbchem.chosen == "saflin") {
            this.saflin[b] = this.saflin(t);
        }
        if (this.carbchem.chosen == "cubicfit") {
            this.saflin[b] = this.saflin(t);
            this.cubfitf[b] = this.cubfitf(t) * this.oafdml[b] * this.oafdml[b];
        }
        if (this.carbchem.chosen == "realb" || this.carbchem.chosen == "realj") {
            double tk = t + 273.15;
            this.k0[b] = this.k0(tk);
            this.k1[b] = this.k1(tk);
            this.k2[b] = this.k2(tk);
            this.kb[b] = this.kb(tk);
            this.kw[b] = this.kw(tk);
        }
    }

    double safnonlin(double xsc, int b) {
        if (this.carbchem.chosen == "hildaz0z1") {
            return this.saflin[b] * this.gamma[b] * xsc * xsc / (1.0 - this.gamma[b] * xsc) + (this.chemfeedback.istrue() ? xsc * (this.saflin[b] - this.saflin0[b]) : 0.0);
        }
        if (this.carbchem.chosen == "cubicfit") {
            return this.cubfitf[b] * xsc * xsc * xsc + (this.chemfeedback.istrue() ? xsc * (this.saflin[b] - this.saflin0[b]) : 0.0);
        }
        if (this.carbchem.chosen == "linear" && this.chemfeedback.istrue()) {
            return xsc * (this.saflin[b] - this.saflin0[b]);
        }
        if (this.carbchem.chosen == "realb" || this.carbchem.chosen == "realj") {
            double totc = this.totc0[b] + xsc * this.oafdml[b] / 1000000.0;
            int ncit = 0;
            if (this.carbchem.chosen == "realb") {
                double hydold;
                do {
                    hydold = this.hyd[b];
                    this.calk[b] = this.talk - this.totb * this.kb[b] / (this.hyd[b] + this.kb[b]) - this.kw[b] / this.hyd[b] + this.hyd[b];
                    double root = (totc - this.calk[b]) * (totc - this.calk[b]) - 4.0 * this.calk[b] * (this.calk[b] - 2.0 * totc) * this.k2[b] / this.k1[b];
                    this.hyd[b] = this.k1[b] / (2.0 * this.calk[b]) * (totc - this.calk[b] + Math.pow(root, 0.5));
                } while (Math.abs(1.0 - hydold / this.hyd[b]) > 1.0E-5 && ++ncit < 10);
            } else {
                double ph = 6.0;
                double dph = -0.5;
                double yold = 0.0;
                do {
                    ++ncit;
                    this.hyd[b] = Math.pow(10.0, -ph);
                    double a = (this.k1[b] / this.hyd[b] + 2.0 * this.k1[b] * this.k2[b] / (this.hyd[b] * this.hyd[b])) / (1.0 + this.k1[b] / this.hyd[b] + this.k1[b] * this.k2[b] / (this.hyd[b] * this.hyd[b])) * totc;
                    double y = this.talk - a - this.kb[b] * this.totb / (this.hyd[b] + this.kb[b]) - this.kw[b] / this.hyd[b] + this.hyd[b];
                    yold = y;
                    ph += (dph *= y / (yold - y));
                } while (Math.abs(dph) > 1.0E-5 && ncit < 10);
            }
            double co2 = totc * (this.hyd[b] * this.hyd[b]) / (this.hyd[b] * this.hyd[b] + this.k1[b] * this.hyd[b] + this.k1[b] * this.k2[b]);
            double bicarb = this.k1[b] * co2 / this.hyd[b];
            double carb = totc - co2 - bicarb;
            this.pH.set(this.calcpK(this.hyd[b]));
            this.carbonate.set((float)carb);
            this.bicarbonate.set((float)bicarb);
            this.co2aq.set((float)co2);
            this.totc02.set((float)totc);
            return this.askoaf[b] * (1000000.0 * co2 / this.k0[b] - 278.0) - this.saflin[b] * xsc;
        }
        return 0.0;
    }

    float calcpK(double d) {
        return (float)(-Math.log(d) / Math.log(10.0));
    }
}

