/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.carbon;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.biomestock;
import jcm.mod.carbon.cell;
import jcm.mod.data.histdata;
import jcm.mod.data.interpolator;
import jcm.mod.data.pngdata;
import jcm.mod.reg.region;
import jcm.mod.reg.regman;
import jcm.mod.reg.regpoly;
import jcm.tls.fileio;

public class CalcLucEmit
extends module {
    Map<Integer, int[][]> luTables = new HashMap<Integer, int[][]>();
    Map<Integer, biomestock> biomestocks = new HashMap<Integer, biomestock>();
    Map<Integer, Map<Integer, Float>> bcm = new HashMap<Integer, Map<Integer, Float>>();
    Set<cell> cellset = new HashSet<cell>();
    static Map<region, Float> countryArcviewAreas = new HashMap<region, Float>();
    public qtset lucemit = new qtset("IVIG32 model LUC emission", "kilo&ton&carbon", 1700, 2002, 1);
    public qtset carbonstock = new qtset("IVIG32 model Carbon Stocks", "kilo&ton&carbon", 1700, 2002, 1);
    public static qtset lucCO2Houghton = new qtset("Houghton LUC emit", "kilo&ton&carbon", 1700, 2002);
    public static qtset lucCO2UNFCCC = new qtset("UNFCCC LUC emit", "kilo&ton&carbon", 1990, 2002);
    public static qtset lucCO2CAIT = new qtset("CAIT LUC emit", "kilo&ton&carbon", 1950, 2000);
    public static qtset lucCO2CAIT1 = new qtset("CAIT-1 LUC emit", "kilo&ton&carbon", 1850, 2000);
    public static qtset faoagr = new qtset("FAO Agriculture Area", "mega&m2", 1961, 2002);
    public static qtset faopast = new qtset("FAO Pasture Area", "mega&m2", 1961, 2002);
    public qtset biomeChosenCountries = new qtset(new Object[]{"1 Biome area all countries plot", "mega&m2", 1700, 2002, complexity.expert});
    public qtset countryChosenBiomes = new qtset(new Object[]{"1 Country all biomes areas plot ", "mega&m2", 1700, 2002, complexity.expert});
    public qtset countryChosenAP = new qtset(new Object[]{"1 Country FAOxModel areas plot", "mega&m2", 1961, 2002, complexity.expert});
    public qtset countryChosenEmission = new qtset(new Object[]{"1 Country all emissions datasets", "kilo&ton&carbon", 1700, 2002, complexity.expert});
    public static qtset edgarff = new qtset(new Object[]{"EDGAR fossil", "kilo&ton&carbon", 1890, 2000, complexity.experimental});
    public static qtset edgarluc = new qtset(new Object[]{"EDGAR LUC", "kilo&ton&carbon", 1890, 2000, complexity.experimental});
    public String[] lucsources = new String[]{"IVIGmodel", "Houghton", "Inverse"};
    public param lucsource = new param(new Object[]{"LUC emit dataset", this.lucsources, "IVIGmodel", complexity.simplest});
    String[] biomeNameA = new String[]{"Ocean", "Cultivated land", "Pasture", "X", "X", "Ice", "Tundra", "Wooded tundra", "Boreal forest", "Cool conifer forest", "Temperate mixed forest", "Temperate deciduous forest", "Warm mixed forest", "Grassland/Steppe", "Hot desert", "Scrubland", "Savanna", "Tropical woodland", "Tropical forest"};
    String[] biomeNameB = new String[]{"Ocean", "Cultivated land", "Pasture", "Tropical Evergreen Forest/Woodland", "Tropical Deciduous Forest/Woodland", "Temperate Broadleafed Evergreen Forest/Woodland", "Temperate Needleleafed Evergreen Forest/Woodland", "Temperate Decidous Forest/Woodland", "Boreal Evergreen Forest/Woodland", "Boreal Deciduous Forest/Woodland", "Evergreen/Deciduous Mixed Forest/Woodland", "Savanna", "Grassland/Steppe", "Dense Shrubland", "Open Shrubland", "Tundra", "Hot Desert", "Polar Deser/Rock/Ice"};
    public param biomeclass = new param(new Object[]{"Biome classification", new String[]{"A", "B"}, "B"}){

        public void precalc() {
            CalcLucEmit.this.biomeList.menulist = CalcLucEmit.this.biomeclass.chosen.equals("A") ? CalcLucEmit.this.biomeNameA : CalcLucEmit.this.biomeNameB;
            CalcLucEmit.this.biomeList.choose("Cultivated land");
            CalcLucEmit.this.countryChosenBiomes.map.clear();
            CalcLucEmit.this.loadHYDEdata();
        }
    };
    public param biomeList;
    public param countryList;
    public param FAO2002;
    public param vegetationCarbon;
    public param isam;
    public param soildecayrate;
    public param soillossagric;
    public param soillosspast;
    public param simplemethod;
    public param grassyon;
    public param shiftcultivation;
    public param shiftcultfrac;
    public param landuseemit;
    static int[] periodsHYDE = new int[]{1700, 1750, 1800, 1850, 1900, 1950, 1970, 1990};
    static int[] periods = new int[]{1700, 1750, 1800, 1850, 1900, 1950, 1970, 1990, 2002};
    float oldstock;
    float newstock;
    float countryModelArea;
    float correcAFAO1970;
    float correcPFAO1970;
    public static Color[] colsA = new Color[]{colfont.black, colfont.red, colfont.pink, colfont.black, colfont.black, colfont.white, colfont.cyan, colfont.dkcyan, colfont.browngreen, colfont.dkredgreen, colfont.dkyellowgreen, colfont.yellowgreen, colfont.olive, colfont.orange, colfont.yellow, colfont.brown, colfont.ltgreen, colfont.green, colfont.dkgreen};
    public static Color[] colsB = new Color[]{colfont.black, colfont.red, colfont.pink, colfont.dkgreen, colfont.green, colfont.dkgrey, colfont.olive, colfont.yellowgreen, colfont.dkredgreen, colfont.dkyellowgreen, colfont.browngreen, colfont.ltgreen, colfont.orange, colfont.brown, colfont.dkbrown, colfont.cyan, colfont.yellow, colfont.white, colfont.black};
    public Map<region, Float> potluc;
    public int startscenluc;
    public int cc;
    static boolean loadeddata = false;

    public CalcLucEmit() {
        this.biomeList = new param(new Object[]{"Biome chosed plot", this.biomeclass.chosen.equals("A") ? this.biomeNameA : this.biomeNameB, "Cultivated land", complexity.expert});
        this.countryList = new param(new Object[]{"Country chosed plot", regman.nations.reg.toArray(new region[0]), regman.nations.find("Brazil"), complexity.expert});
        this.FAO2002 = new param(new Object[]{"FAO agric/past rates of change", true, complexity.expert});
        this.vegetationCarbon = new param(new Object[]{"Vegetation Carbon uncertainty", "", 1, 0.8, 1.2, complexity.expert});
        this.isam = new param(new Object[]{"Biome B/ISAM carbon content", false, complexity.expert});
        this.soildecayrate = new param(new Object[]{"95% soil decay time", "", 20, 0.1, 30, complexity.expert});
        this.soillossagric = new param(new Object[]{"LUC agriculture carbon loss from soil", "", 0.2, 0.1, 0.3, complexity.expert});
        this.soillosspast = new param(new Object[]{"LUC pasture carbon loss from soil", "", 0.05, 0.01, 0.1, complexity.expert});
        this.simplemethod = new param(new Object[]{"Simple soil emissions (IVIG31)", false, complexity.experimental});
        this.grassyon = new param(new Object[]{"Grassy soil carbon", false, complexity.experimental});
        this.shiftcultivation = new param(new Object[]{"Shifting cultivation", false, complexity.experimental});
        this.shiftcultfrac = new param(new Object[]{"Shifting cultivation fraction", "", 0.05, 0.01, 0.1, complexity.experimental});
        this.landuseemit = new param(new Object[]{"lucfemit1990", "mega&ton&carbon&per&yr", 2158.09, 0, 3000, complexity.expert});
        this.potluc = new HashMap<region, Float>();
    }

    static void getdata() {
        CalcLucEmit.reporttime("begin CLE loaddata");
        for (region r : regman.nations.reg) {
            r.makepolys();
        }
        System.err.println("Running CalcLucEmit");
        CalcLucEmit.loadStaticData();
        CalcLucEmit.reporttime("end CLE loaddata");
        loadeddata = true;
    }

    public void precalc() {
        if (!loadeddata) {
            CalcLucEmit.getdata();
        }
        switch (this.biomeclass.getchosenindex()) {
            case 0: {
                this.cc = 0;
                break;
            }
            case 1: {
                int n = this.cc = !this.isam.istrue() ? 1 : 2;
            }
        }
        if (this.lucsource.chosen.equals("IVIGmodel")) {
            this.runmodel();
        }
        this.calcpots();
    }

    public static void main(String[] args) {
        for (region r : regman.nations.reg) {
            r.makepolys();
        }
        CalcLucEmit c = new CalcLucEmit();
        c.loadHYDEdata();
        c.runmodel();
    }

    public void runmodel() {
        CalcLucEmit.reporttime("begin CLE runmodel");
        this.countryChosenBiomes.map.clear();
        this.countryChosenAP.map.clear();
        for (region r : regman.nations.reg) {
            this.findCells(r);
            this.calcInitialStock(r);
            this.setqtcolors(r);
            for (int i = 0; i < periods.length; ++i) {
                if (i == 0) continue;
                if (i < 8) {
                    this.calcBiomeChangeMap(i, i - 1, r);
                }
                for (int year = periods[i - 1] + 1; year <= periods[i]; year += this.lucemit.xstep) {
                    this.calcAreaChange(i, r, year);
                    this.calcEmit(i, r, year);
                }
            }
        }
        CalcLucEmit.reporttime("end CLE runmodel");
    }

    void calcAreaChange(int i, region r, int year) {
        float totachange = 0.0f;
        float totpchange = 0.0f;
        float totHYDEachange = 0.0f;
        float totHYDEpchange = 0.0f;
        float totaptransfer = 0.0f;
        if (year > 1961 && this.FAO2002.istrue()) {
            float area;
            float totFAOachange = faoagr.get(r, year) - faoagr.get(r, year - 1);
            float totFAOpchange = faopast.get(r, year) - faopast.get(r, year - 1);
            totHYDEachange = 0.0f;
            totHYDEpchange = 0.0f;
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    if (f <= 0 || t <= 0) continue;
                    area = this.bcm.get(f).get(t).floatValue();
                    if (t == 1) {
                        totHYDEachange += area;
                    }
                    if (f != 1) continue;
                    totHYDEachange -= area;
                }
            }
            if (totHYDEachange == 0.0f) {
                float flag = 10.0f;
                if (!this.bcm.containsKey(1)) {
                    this.bcm.put(1, new HashMap());
                }
                if (!this.bcm.get(1).containsKey(2)) {
                    this.bcm.get(1).put(2, Float.valueOf(flag));
                }
                totHYDEachange -= flag;
            }
            float correcfaca = totFAOachange / totHYDEachange;
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    if (f <= 0 || t <= 0) continue;
                    area = this.bcm.get(f).get(t).floatValue();
                    if (t == 1 && f == 2) {
                        totaptransfer -= area * correcfaca;
                    }
                    if (f != 1 || t != 2) continue;
                    totaptransfer += area * correcfaca;
                }
            }
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    if (f <= 1 || t <= 1) continue;
                    area = this.bcm.get(f).get(t).floatValue();
                    if (f == 2) {
                        totHYDEpchange += area;
                    }
                    if (t != 2) continue;
                    totHYDEpchange += area;
                }
            }
            if (totHYDEpchange == 0.0f) {
                int biomeC = 0;
                float areaB = 0.0f;
                for (int b = 3; b < (this.biomeclass.chosen.equals("A") ? 19 : 18); ++b) {
                    if (!this.biomestocks.containsKey(b) || !(areaB < this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea)) continue;
                    areaB = this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea;
                    biomeC = b;
                }
                float flag = 10.0f;
                if (!this.bcm.containsKey(biomeC)) {
                    this.bcm.put(biomeC, new HashMap());
                }
                if (!this.bcm.get(biomeC).containsKey(2)) {
                    this.bcm.get(biomeC).put(2, Float.valueOf(flag));
                }
                totHYDEachange -= flag;
            }
            float correcfacp = totHYDEpchange != 0.0f ? (totFAOpchange - totaptransfer) / totHYDEpchange : 1.0f;
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    float available;
                    if (f <= 0 || t <= 0) continue;
                    area = this.bcm.get(f).get(t).floatValue();
                    if (f == 1 || t == 1) {
                        area *= correcfaca;
                    }
                    if (f == 2 && t != 1) {
                        area *= -correcfacp;
                    }
                    if (f != 1 && t == 2) {
                        area *= correcfacp;
                    }
                    float f2 = available = area >= 0.0f ? this.biomestocks.get((Object)f).totarea : this.biomestocks.get((Object)t).totarea;
                    if (available < Math.abs(area)) {
                        int biomeC = 0;
                        float areaB = 0.0f;
                        for (Integer from : this.bcm.keySet()) {
                            for (Integer to : this.bcm.get(from).keySet()) {
                                if (from > 2 && areaB < this.biomestocks.get((Object)from).totarea && this.biomestocks.get((Object)from).totarea > area) {
                                    biomeC = from;
                                    areaB = this.biomestocks.get((Object)from).totarea;
                                }
                                if (to <= 2 || !(areaB < this.biomestocks.get((Object)to).totarea) || !(this.biomestocks.get((Object)to).totarea > area)) continue;
                                biomeC = to;
                                areaB = this.biomestocks.get((Object)to).totarea;
                            }
                        }
                        if (biomeC == 0) {
                            for (int b = 3; b < (this.biomeclass.chosen.equals("A") ? 19 : 18); ++b) {
                                if (!this.biomestocks.containsKey(b) || !(areaB < this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea)) continue;
                                areaB = this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea;
                                biomeC = b;
                            }
                        }
                        if (area > 0.0f && biomeC > 2) {
                            f = biomeC;
                        }
                        if (area < 0.0f && biomeC > 2) {
                            t = biomeC;
                        }
                    }
                    if (!(area > 1.0f) && !(area < -1.0f)) continue;
                    this.transfer(area, f, t);
                }
            }
            this.shiftcultivation();
        } else {
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    float available;
                    if (f <= 0 || t <= 0) continue;
                    float area = this.bcm.get(f).get(t).floatValue();
                    float f3 = available = area >= 0.0f ? this.biomestocks.get((Object)f).totarea : this.biomestocks.get((Object)t).totarea;
                    if (available < Math.abs(area)) {
                        int biomeC = 0;
                        float areaB = 0.0f;
                        for (Integer from : this.bcm.keySet()) {
                            for (Integer to : this.bcm.get(from).keySet()) {
                                if (from > 2 && areaB < this.biomestocks.get((Object)from).totarea && this.biomestocks.get((Object)from).totarea > area) {
                                    biomeC = from;
                                    areaB = this.biomestocks.get((Object)from).totarea;
                                }
                                if (to <= 2 || !(areaB < this.biomestocks.get((Object)to).totarea) || !(this.biomestocks.get((Object)to).totarea > area)) continue;
                                biomeC = to;
                                areaB = this.biomestocks.get((Object)to).totarea;
                            }
                        }
                        if (biomeC == 0) {
                            for (int b = 3; b < (this.biomeclass.chosen.equals("A") ? 19 : 18); ++b) {
                                if (!this.biomestocks.containsKey(b) || !(areaB < this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea)) continue;
                                areaB = this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea;
                                biomeC = b;
                            }
                        }
                        if (area > 0.0f && biomeC > 2) {
                            f = biomeC;
                        }
                        if (area < 0.0f && biomeC > 2) {
                            t = biomeC;
                        }
                    }
                    this.transfer(area, f, t);
                    this.shiftcultivation();
                }
            }
        }
    }

    void calcEmit(int i, region r, int year) {
        this.newstock = 0.0f;
        for (biomestock s : this.biomestocks.values()) {
            s.decayregrow(this.lucemit.xstep);
            this.newstock += s.totstock();
        }
        float emit = (this.oldstock - this.newstock) / (float)this.lucemit.xstep;
        if (Float.isNaN(emit) || Float.isInfinite(emit)) {
            emit = 0.0f;
        }
        this.oldstock = Float.isNaN(this.newstock) ? this.oldstock : this.newstock;
        this.lucemit.set(r, year, emit);
        this.carbonstock.set(r, year, this.oldstock);
        this.setcountryqts(r, year);
    }

    void transfer(float area, int f, int t) {
        if (area < 0.0f) {
            int ff = f;
            f = t;
            t = ff;
            area = -area;
        }
        this.biomestocks.get(f).cutdown(area, this.biomestocks.get(t));
        this.biomestocks.get(t).setregrow(area, this.biomestocks.get(f));
    }

    void calcInitialStock(region r) {
        this.biomestocks.clear();
        this.biomestocks.put(1, new biomestock(1, 0.0f, this));
        this.biomestocks.put(2, new biomestock(2, 0.0f, this));
        for (cell c : this.cellset) {
            int x = (int)((double)(c.lon * 2.0f) + 359.5);
            int y = (int)((double)(-c.lat * 2.0f) + 180.5);
            try {
                int biome = this.luTables.get(1700)[x][y];
                if (biome == 0) continue;
                if (!this.biomestocks.containsKey(biome)) {
                    this.biomestocks.put(biome, new biomestock(biome, 0.0f, this));
                }
                this.biomestocks.get(biome).addarea(c.area);
            }
            catch (Exception e) {
                System.err.println(x + " " + y + e);
                e.printStackTrace();
            }
        }
        this.setcountryqts(r, 1700);
        this.countryAreasCorrection(r);
        this.oldstock = 0.0f;
        for (biomestock bs : this.biomestocks.values()) {
            this.oldstock += bs.totstock();
            bs.potvegstock = bs.vegstock;
            bs.potsoilstock = bs.soilstock;
        }
    }

    void calcBiomeChangeMap(int b, int a, region r) {
        int nstep = (periods[b] - periods[a]) / this.lucemit.xstep;
        this.bcm.clear();
        for (cell c : this.cellset) {
            int biomeFrom;
            int x = (int)((double)(c.lon * 2.0f) + 359.5);
            int y = (int)((double)(-c.lat * 2.0f) + 180.5);
            int biomeTo = this.luTables.get(periods[b])[x][y];
            if (biomeTo == (biomeFrom = this.luTables.get(periods[a])[x][y])) continue;
            if (!this.bcm.containsKey(biomeFrom)) {
                this.bcm.put(biomeFrom, new HashMap());
            }
            if (!this.bcm.get(biomeFrom).containsKey(biomeTo)) {
                this.bcm.get(biomeFrom).put(biomeTo, Float.valueOf(0.0f));
            }
            this.bcm.get(biomeFrom).put(biomeTo, Float.valueOf(this.bcm.get(biomeFrom).get(biomeTo).floatValue() + c.area / (float)nstep));
        }
    }

    public void calcpots() {
        this.startscenluc = this.lucsource.chosen.equals("Houghton") ? 2001 : 2003;
        System.err.println("CALCPOTSRUN");
        for (region r : regman.nations.reg) {
            int y;
            this.potluc.put(r, Float.valueOf(0.0f));
            if (this.lucsource.chosen.equals("IVIGmodel")) {
                for (y = 1700; y < this.startscenluc; ++y) {
                    this.potluc.put(r, Float.valueOf(this.potluc.get(r).floatValue() + this.lucemit.get(r, y) / 1000.0f));
                }
            }
            if (!this.lucsource.chosen.equals("Houghton")) continue;
            for (y = 1850; y < this.startscenluc; ++y) {
                this.potluc.put(r, Float.valueOf(this.potluc.get(r).floatValue() + lucCO2CAIT1.get(r, y) / 1000.0f));
            }
        }
    }

    void shiftcultivation() {
        if (this.shiftcultivation.istrue() && this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea > 100000.0f) {
            float areaB = 0.0f;
            int B = 0;
            for (int b = 3; b < (this.biomeclass.chosen.equals("A") ? 19 : 18); ++b) {
                if (!this.biomestocks.containsKey(b) || !(areaB < this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea)) continue;
                B = b;
            }
            this.transfer(this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea * (float)this.shiftcultfrac.getval() / 100.0f, 1, B);
            this.transfer(this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea * (float)this.shiftcultfrac.getval() / 100.0f, B, 1);
        }
    }

    static void loadStaticData() {
        histdata.loaddata(faopast, "FAO_pasture.csv", "\t", true, 1.0f, 1961, 2002, 1961);
        histdata.loaddata(faoagr, "FAO_agriculture.csv", "\t", true, 1.0f, 1961, 2002, 1961);
        histdata.loaddata(lucCO2Houghton, "houghtondata2000.csv", ";", true, 1000.0f, 1850, 2000, 1850);
        String[][] countrya = fileio.loadtab("data/Country_areas.csv", "\t");
        for (int y = 3; y < countrya.length; ++y) {
            region r = regman.allreg.find(countrya[y][0]);
            float area = Float.parseFloat(countrya[y][1]);
            countryArcviewAreas.put(r, Float.valueOf(!countryArcviewAreas.containsKey(r) ? area : countryArcviewAreas.get(r).floatValue() + area));
        }
        histdata.loaddata(lucCO2UNFCCC, "UNFCCC_LUC_emit.tab", "\t", true, 0.27272728f, 1990, 2002, 1990);
        histdata.loaddata(lucCO2CAIT, "CAIT_LUC_emit.tab", "\t", true, 1.0f, 1950, 2000, 1950);
        new interpolator(lucCO2Houghton, "HOUGHTON", 1950, Float.valueOf(1.0f)).fill(lucCO2CAIT1, regman.nations, 1850, 2000, lucCO2CAIT);
    }

    void loadHYDEdata() {
        for (int j : periodsHYDE) {
            String filename = "lu_" + this.biomeclass.chosen + "_" + j;
            int[][] data = pngdata.load(filename + ".png", this.biomeclass.chosen.equals("A") ? colsA : colsB);
            this.luTables.put(j, data);
        }
    }

    static void loadEDGAR() {
    }

    void countryAreasCorrection(region r) {
        float totHYDEachange = 0.0f;
        float totHYDEpchange = 0.0f;
        if (countryArcviewAreas.containsKey(r) && this.countryModelArea != 0.0f) {
            float correcArea = countryArcviewAreas.get(r).floatValue() / this.countryModelArea - 1.0f;
            for (int b = 1; b < (this.biomeclass.chosen.equals("A") ? 19 : 18); ++b) {
                if (!this.biomestocks.containsKey(b)) continue;
                this.biomestocks.get(b).addarea(correcArea * this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea);
            }
        }
    }

    void setcountryqts(region r, int year) {
        float carea = 0.0f;
        this.biomeChosenCountries.set(r, year, this.biomestocks.containsKey(this.biomeList.getchosenindex()) ? this.biomestocks.get((Object)Integer.valueOf((int)this.biomeList.getchosenindex())).totarea : 0.0f);
        if (r == this.countryList.getchosen()) {
            this.countryChosenAP.set("Model Agric", year, this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea);
            this.countryChosenAP.set("FAO Agric", year, faoagr.get(r, year));
            this.countryChosenAP.set("Model Past", year, this.biomestocks.get((Object)Integer.valueOf((int)2)).totarea);
            this.countryChosenAP.set("FAO Past", year, faopast.get(r, year));
            if (year < 2003) {
                this.countryChosenEmission.set("IVIG32 model", year, this.lucemit.get(r, year));
            }
            if (year > 1989 && year < 2003) {
                this.countryChosenEmission.set("UNFCCC", year, lucCO2UNFCCC.get(r, year));
            }
            if (year > 1949 && year < 2001) {
                this.countryChosenEmission.set("CAIT", year, lucCO2CAIT.get(r, year));
            }
            if (year > 1850 && year < 2001) {
                this.countryChosenEmission.set("CAIT-1", year, lucCO2CAIT1.get(r, year));
            }
        }
        for (int b = 1; b < (this.biomeclass.chosen.equals("A") ? 19 : 18); ++b) {
            if (!this.biomestocks.containsKey(b)) continue;
            carea += this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea;
            if (r != this.countryList.getchosen() || !this.biomestocks.containsKey(b)) continue;
            this.countryChosenBiomes.set(this.biomeList.getname(b), year, this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea);
        }
        this.countryModelArea = carea;
    }

    void setqtcolors(region r) {
        if (r == this.countryList.getchosen()) {
            this.countryChosenAP.add(new qt("Model Agric", colfont.red, 1962, 2002));
            this.countryChosenAP.add(new qt("FAO Agric", colfont.dkred, 1962, 2002));
            this.countryChosenAP.add(new qt("Model Past", colfont.pink, 1962, 2002));
            this.countryChosenAP.add(new qt("FAO Past", colfont.magenta, 1962, 2002));
            this.countryChosenEmission.add(new qt("IVIG32 model", colfont.red, 1700, 2002));
            this.countryChosenEmission.add(new qt("UNFCCC", colfont.blue, 1990, 2002));
            this.countryChosenEmission.add(new qt("CAIT", colfont.pink, 1950, 2000));
            this.countryChosenEmission.add(new qt("CAIT-1", colfont.yellow, 1850, 2000));
            for (int b = 1; b < (this.biomeclass.chosen.equals("A") ? 19 : 18); ++b) {
                if (!this.biomestocks.containsKey(b)) continue;
                this.countryChosenBiomes.add(new qt(this.biomeList.getname(b), this.biomeclass.equals("A") ? colsA[b] : colsB[b], 1700, 2002));
            }
        }
    }

    void findCells(region r) {
        this.cellset.clear();
        double area = 0.0;
        double sum = 0.0;
        double sumarea = 0.0;
        double dudarea = 0.0;
        for (regpoly p : r.polyset) {
            Area a = new Area(p);
            Rectangle box = a.getBounds();
            int step = 5;
            for (int xo = box.x; xo < box.x + box.width; xo += step) {
                int xd = Math.min(box.x + box.width - xo, step);
                for (int yo = box.y; yo < box.y + box.height; yo += step) {
                    int yd = Math.min(box.y + box.height - yo, step);
                    if (!a.intersects(xo, yo, xd, yd)) continue;
                    boolean inbox = a.contains(xo, yo, xd, yd);
                    float yi = -0.25f + (float)yo;
                    while (yi < -0.25f + (float)yo + (float)yd) {
                        area = Math.cos(Math.PI * (double)yi / 180.0);
                        float xi = 0.25f + (float)xo;
                        while (xi < 0.25f + (float)xo + (float)xd) {
                            if (inbox || a.contains(xi, yi)) {
                                cell c = new cell();
                                c.lon = xi;
                                c.lat = yi;
                                c.area = (float)(area * Math.pow(55.563, 2.0));
                                this.cellset.add(c);
                            }
                            xi = (float)((double)xi + 0.5);
                        }
                        yi = (float)((double)yi + 0.5);
                    }
                }
            }
        }
    }
}

