/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;
import jcm.core.param;
import jcm.core.qtset;
import jcm.core.register;
import jcm.gui.plot.baseplot;
import jcm.gui.plot.scaleview;

public class scatterplot
extends baseplot {
    qtset qq2;

    public scatterplot(Object[] args) {
        this.qq = (qtset)args[0];
        this.qq2 = (qtset)args[1];
        this.setup(this.qq);
        this.xsv.setMinimumSize(new Dimension(0, 40));
    }

    void makeplot() {
        this.plot = new scatter();
    }

    void makescales() {
        this.yscale = this.qq.getyscale();
        this.xscale = this.qq2.getyscale();
        this.xscale.type = param.Type.Xscale;
        this.ysv = new scaleview(this.yscale);
        this.xsv = new scaleview(this.xscale);
        register.addlink(this, this.xscale, this.yscale);
    }

    class scatter
    extends JPanel {
        scatter() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldat = g2.getTransform();
            float xsf = (float)this.getWidth() / scatterplot.this.xscale.range();
            float ysf = (float)(-this.getHeight()) / scatterplot.this.yscale.range();
            float xyf = xsf / ysf;
            g2.scale(ysf, ysf);
            g2.translate(-scatterplot.this.xscale.min() * xyf, -scatterplot.this.yscale.max());
            g2.setStroke(new BasicStroke(Math.abs(scatterplot.this.yscale.range()) / 250.0f));
            int sy = Math.max(scatterplot.this.qq.sy, scatterplot.this.qq2.sy);
            int ey = Math.min(scatterplot.this.qq.ey, scatterplot.this.qq2.ey);
            GeneralPath line = new GeneralPath();
            for (Object o : scatterplot.this.qq.map.keySet()) {
                if (!scatterplot.this.qq2.map.containsKey(o)) continue;
                line.reset();
                line.moveTo(scatterplot.this.qq2.get(o, sy) * xyf, scatterplot.this.qq.get(o, sy));
                for (int year = sy + 1; year <= ey; ++year) {
                    line.lineTo(scatterplot.this.qq2.get(o, year) * xyf, scatterplot.this.qq.get(o, year));
                }
                try {
                    g2.setColor(scatterplot.this.qq.map.get((Object)o).color);
                    g2.draw(line);
                    System.err.println(o);
                }
                catch (Error e) {
                    System.err.println("line drawing error");
                }
            }
            g2.setTransform(oldat);
            g2.dispose();
            scatterplot.this.ready = true;
        }
    }
}

