/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jcm.core.interacob;
import jcm.core.param;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.plot.baseplot;

public class scaleview
extends JPanel
implements MouseInputListener {
    public static param linkx = new param("linkx", false);
    public static param showscales = new param("showscales", true);
    param sp;
    float fac = baseplot.bigfont ? 2.0f : 1.0f;
    public double origin;
    public double dp;
    int ep;
    int op;
    boolean dragorigin = false;

    public scaleview(param sp) {
        this.sp = sp;
        param.Type cfr_ignored_0 = sp.type;
        this.origin = sp.type == param.Type.Xscale ? 2000.0 : 0.0;
        this.setBackground(Color.white);
        param.Type cfr_ignored_1 = sp.type;
        this.setPreferredSize(sp.type == param.Type.Xscale ? new Dimension(0, (int)(24.0f * this.fac)) : new Dimension((int)(36.0f * this.fac), 0));
        this.setToolTipText(labman.getTitle(sp.getstate()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        param.Type cfr_ignored_2 = sp.type;
        this.setCursor(new Cursor(sp.type == param.Type.Xscale ? 11 : 8));
        param.Type cfr_ignored_3 = sp.type;
        if (sp.type == param.Type.Xscale) {
            sp.setaffectedby((interacob)linkx);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (baseplot.bigfont) {
            g.setFont(colfont.vbigbold);
        }
        int w = this.getWidth();
        int h = this.getHeight();
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            g.drawLine(0, 0, w, 0);
        }
        param.Type cfr_ignored_1 = this.sp.type;
        if (this.sp.type == param.Type.Yscale) {
            g.drawLine(w - 1, 0, w - 1, h);
        }
        if (this.sp.units.scales != 0.0) {
            for (double v = this.sp.units.minstep(this.sp.min()); v <= (double)this.sp.max(); v += this.sp.units.scales) {
                int p = this.pixel(v);
                String s = this.sp.units.round(v);
                int sw = this.sw(g, s);
                param.Type cfr_ignored_2 = this.sp.type;
                if (this.sp.type == param.Type.Xscale) {
                    g.drawLine(p, 0, p, 5);
                    if (h > 8) {
                        g.drawString(s, p - sw / 2, h - 4);
                    }
                }
                param.Type cfr_ignored_3 = this.sp.type;
                if (this.sp.type != param.Type.Yscale) continue;
                g.drawLine(w - 5, p, w, p);
                if (w <= 8) continue;
                g.drawString(s, w - (sw + 5), p + 4);
            }
        }
        param.Type cfr_ignored_4 = this.sp.type;
        if (this.sp.type == param.Type.Yscale) {
            Graphics2D g2 = (Graphics2D)g;
            g.translate((int)(8.0f * this.fac), 20 + this.getHeight() / 2);
            g2.rotate(-1.5707963267948966);
            g.drawString(labman.getTitle(this.sp.units.units), 0, 0);
        }
    }

    int pixel(double v) {
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            return (int)((double)this.getWidth() * (v - (double)this.sp.min()) / (double)this.sp.range());
        }
        return this.getHeight() - (int)((double)this.getHeight() * (v - (double)this.sp.min()) / (double)this.sp.range());
    }

    double real(int p) {
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            return this.sp.min() + (float)p * this.sp.range() / (float)this.getWidth();
        }
        return this.sp.min() + (float)(this.getHeight() - p) * this.sp.range() / (float)this.getHeight();
    }

    public int sw(Graphics g, String s) {
        try {
            return g.getFontMetrics(g.getFont()).stringWidth(s);
        }
        catch (Exception e) {
            return 8;
        }
    }

    public void mouseDragged(MouseEvent e) {
        param.Type cfr_ignored_0 = this.sp.type;
        int n = this.ep = this.sp.type == param.Type.Xscale ? e.getX() : e.getY();
        if (this.dragorigin) {
            param.Type cfr_ignored_1 = this.sp.type;
            this.dp = (double)((float)(this.ep - this.op) * this.sp.range()) / (double)(this.sp.type == param.Type.Xscale ? -this.getWidth() : this.getHeight());
            this.sp.max += this.dp;
            this.sp.min += this.dp;
        } else {
            this.dp = ((double)this.op - (double)this.pixel(this.origin)) / ((double)this.ep - (double)this.pixel(this.origin));
            this.sp.max = this.origin + ((double)this.sp.max() - this.origin) * this.dp;
            this.sp.min = this.origin + ((double)this.sp.min() - this.origin) * this.dp;
        }
        this.op = this.ep;
        this.sp.respond(true);
        this.setToolTipText(labman.getTitle(this.sp.getstate()));
        this.sp.units.checkunitfac(this.sp.max() - this.sp.min());
        this.sp.units.checkunitcancel();
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        param.Type cfr_ignored_0 = this.sp.type;
        this.op = this.sp.type == param.Type.Xscale ? e.getX() : e.getY();
        boolean bl = this.dragorigin = e.getClickCount() > 1;
        if (this.dragorigin) {
            this.origin = this.real(this.op);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragorigin = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

