/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import jcm.core.loop;
import jcm.core.param;
import jcm.core.plotlink;
import jcm.core.register;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.contextMenu;
import jcm.gui.gen.imagesaver;
import jcm.gui.nav.menuFiller;
import jcm.gui.nav.showpan;
import jcm.gui.plot.colorscale;
import jcm.mod.reg.mapprojection;
import jcm.mod.reg.regcli;
import jcm.mod.reg.region;
import jcm.mod.reg.regman;
import jcm.mod.reg.regpoly;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mapplot
extends JPanel
implements menuFiller {
    public param startlon = new param("mapstartlongitude", "degrees", 349, 0, 360);
    public param projection = mapprojection.getparam();
    public param<region> regions;
    public double mx;
    public double oldmx;
    public double my;
    public region insidereg;
    JPanel intpan;
    map map;
    public boolean firsttime = true;
    public boolean needtoclear = true;
    public boolean addedyet = false;
    public boolean leftmap = false;
    public boolean inside = false;
    public boolean newpolys = true;
    public boolean updatecolorscale = false;
    public boolean ownregions = false;

    mapprojection getprojection() {
        return (mapprojection)this.projection.chosen;
    }

    public mapplot(regcli rc) {
        if (this.regions == null) {
            this.regions = regman.makeregionparam();
            this.ownregions = true;
        }
        this.setName(labman.getTitle(rc.getFullName() + "&map"));
        this.map = new map(rc);
        this.setup();
    }

    public mapplot(param<region> p) {
        this.regions = p;
        this.map = new map(null);
        this.setName(labman.getTitle(p.getFullName() + "&map"));
        this.setup();
    }

    void setup() {
        this.setToolTipText(this.getName());
        this.setPreferredSize(new Dimension(400, 300));
        JMenuBar mb = new JMenuBar();
        mb.add(this.projection.getMenuItem());
        mb.add(this.regions.getMenuItem());
        this.setLayout(new BorderLayout());
        this.add((Component)mb, "North");
        this.intpan = new JPanel();
        this.intpan.setLayout(new BorderLayout());
        this.intpan.add(this.map);
        if (this.map.cols != null) {
            this.intpan.add((Component)this.map.cols, "South");
        }
        this.add(this.intpan);
        this.setCursor(new Cursor(1));
        new contextMenu(this.map, this);
    }

    @Override
    public void fillMenu(JPopupMenu popup) {
        popup.add(imagesaver.copyaction(this.intpan));
        popup.add(imagesaver.saveimagemenu(this.intpan, "JCM-map"));
        popup.add(showpan.pan("Show doc", docview.class, "mapplot"));
    }

    class map
    extends JPanel
    implements MouseInputListener,
    plotlink {
        JLabel info = new JLabel();
        regcli rc;
        colorscale cols;
        boolean ready = false;
        Polygon[] plotpoly;
        Color[] plotcolor;
        int ow = 0;
        int oh = 0;

        map(regcli mapsource) {
            this.setLayout(null);
            this.setBackground(Color.white);
            this.add(this.info);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            register.addlink(this, mapplot.this.regions, mapplot.this.projection, mapplot.this.startlon);
            if (mapsource != null) {
                this.rc = mapsource;
                this.cols = new colorscale(this.rc);
                register.addlink(this, this.rc, this.cols.rescale);
            }
            loop.go();
            this.ready = true;
        }

        public void doplot() {
            this.makepolys();
            this.repaint();
        }

        public boolean isShowing() {
            return !this.ready || super.isShowing();
        }

        public void removeNotify() {
            super.removeNotify();
            mapplot.this.projection.dispose();
            mapplot.this.startlon.dispose();
            if (this.cols != null) {
                this.cols.rescale.dispose();
            }
            if (mapplot.this.ownregions) {
                mapplot.this.regions.dispose();
            }
            loop.go();
        }

        void makepolys() {
            block16: {
                region rs;
                boolean regchanged;
                block14: {
                    block15: {
                        int w = this.getWidth();
                        int h = this.getHeight();
                        boolean sizechanged = w != this.ow || h != this.oh || mapplot.this.startlon.changed || mapplot.this.projection.changed;
                        boolean bl = regchanged = mapplot.this.firsttime || mapplot.this.regions.changed;
                        if (sizechanged) {
                            mapplot.this.getprojection().setsize(0, 0, w, h, (int)mapplot.this.startlon.val);
                        }
                        this.ow = w;
                        this.oh = h;
                        rs = (region)mapplot.this.regions.chosen;
                        if (regchanged) {
                            rs.makepolys();
                            for (region r : rs.reg) {
                                r.makepolys();
                            }
                        }
                        if (regchanged || this.plotpoly == null) {
                            this.plotcolor = new Color[rs.reg.size()];
                            int np = 0;
                            for (region r : rs.reg) {
                                np += r.polyset.size();
                            }
                            this.plotpoly = new Polygon[np];
                        }
                        if (regchanged || sizechanged) {
                            mapprojection mp = mapplot.this.getprojection();
                            int np = 0;
                            for (region r : rs.reg) {
                                for (regpoly p : r.polyset) {
                                    this.plotpoly[np] = mp.translate(p);
                                    ++np;
                                }
                            }
                        }
                        if (this.rc == null) break block14;
                        if (this.rc.dataset.changed || this.rc.quantity.changed) {
                            mapplot.this.updatecolorscale = true;
                        }
                        if (regcli.ready && mapplot.this.updatecolorscale) {
                            this.cols.setdata(this.rc.d1);
                            this.cols.repaint();
                            mapplot.this.updatecolorscale = false;
                        }
                        if (regchanged) break block15;
                        if (!this.rc.changed) break block16;
                        if (!regcli.ready) break block16;
                    }
                    int nr = 0;
                    for (region r : rs.reg) {
                        this.plotcolor[nr] = this.rc.quantity.chosen.equals("mix&tmx&tmn&pre") ? this.cols.mixregcolor(r) : this.cols.getcolor(r.avg(this.rc.d1));
                        ++nr;
                    }
                    break block16;
                }
                if (regchanged) {
                    int nr = 0;
                    for (region r : rs.reg) {
                        this.plotcolor[nr] = r.getColor();
                        ++nr;
                    }
                }
            }
            mapplot.this.firsttime = false;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.makepolys();
            region rs = (region)mapplot.this.regions.chosen;
            int nr = 0;
            int np = 0;
            for (region r : rs.reg) {
                g.setColor(this.plotcolor[nr]);
                ++nr;
                for (regpoly p : r.polyset) {
                    g.fillPolygon(this.plotpoly[np]);
                    ++np;
                }
            }
            g.setColor(Color.black);
            np = 0;
            for (region r : rs.reg) {
                for (regpoly p : r.polyset) {
                    g.drawPolygon(this.plotpoly[np]);
                    ++np;
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.findpos(e);
            if (mapplot.this.inside) {
                mapplot.this.startlon.val = (int)(((double)((int)mapplot.this.startlon.val) + (mapplot.this.mx - mapplot.this.oldmx) + 360.0) % 360.0);
                mapplot.this.newpolys = true;
                mapplot.this.startlon.respond(true);
            }
        }

        public void mouseMoved(MouseEvent e) {
            this.findpos(e);
            if (mapplot.this.inside) {
                this.writepos();
            }
        }

        public void mousePressed(MouseEvent e) {
            this.findpos(e);
            if (mapplot.this.inside) {
                mapplot.this.oldmx = mapplot.this.mx;
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        void findpos(MouseEvent e) {
            this.findpos(e.getX(), e.getY());
        }

        void findpos(int x, int y) {
            Point p = mapplot.this.getprojection().translateback(x, y);
            mapplot.this.mx = p.x;
            mapplot.this.my = p.y;
            mapplot.this.inside = mapplot.this.my < 90.0 && mapplot.this.my > -90.0 && mapplot.this.mx < 180.0 && mapplot.this.mx > -180.0;
            mapplot.this.insidereg = this.findreg(x, y);
            this.info.setLocation(x + 4, y + 4);
        }

        public region findreg(int x, int y) {
            for (region r : ((region)mapplot.this.regions.chosen).reg) {
                if (!r.contains(mapplot.this.getprojection().translateback(x, y))) continue;
                return r;
            }
            return null;
        }

        public void writepos() {
            this.info.setText(mapplot.this.inside ? this.latlon() + " " + (mapplot.this.insidereg != null ? this.reginfo(mapplot.this.insidereg) : "") : "");
            this.info.setSize(this.info.getPreferredSize());
        }

        public String latlon() {
            return (int)Math.abs(mapplot.this.my) + (mapplot.this.my > 0.0 ? " N" : " S") + " " + (int)Math.abs(mapplot.this.mx) + (mapplot.this.mx > 0.0 ? " E" : " W");
        }

        public String reginfo(region r) {
            if (this.rc == null) {
                return mapplot.this.insidereg.getName();
            }
            return mapplot.this.insidereg.getName() + " " + this.dp(r.avg(this.rc.d1), 100.0f) + "    ";
        }

        public float dp(float f, float g) {
            return (float)((int)(g * f)) / g;
        }
    }
}

