/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.core.register;
import jcm.gui.doc.labman;
import jcm.gui.plot.baseplot;

public class lineplot
extends baseplot {
    Type mytype = Type.normal;
    boolean stacked = false;
    public static int thin = 250;

    public lineplot(Object[] args) {
        for (Object o : args) {
            if (o.toString().equals("stacked")) {
                this.stacked = true;
            }
            for (Type t : Type.values()) {
                if (!o.toString().equals(t.name())) continue;
                this.mytype = t;
            }
            if (!(o instanceof qtset)) continue;
            if (this.qq == null) {
                this.qq = (qtset)o;
                continue;
            }
            if (this.mytype != Type.ratio) continue;
            this.qq = this.qq.divby((qtset)o);
            this.temporaryqq = true;
        }
        if (this.mytype == Type.rate) {
            this.qq = this.qq.differentiate();
            this.temporaryqq = true;
        }
        this.setup(this.qq);
    }

    public lineplot(qtset qq) {
        this.setup(qq);
    }

    void makeplot() {
        this.plot = new lineplotmainpan();
    }

    public void fillMenu(JPopupMenu popup) {
        if (!this.temporaryqq) {
            popup.add(new AbstractAction("Stack Curves"){

                public void actionPerformed(ActionEvent e) {
                    lineplot.this.changestack();
                }
            });
            popup.addSeparator();
        }
        super.fillMenu(popup);
    }

    public void changestack() {
        this.stacked = !this.stacked;
        this.yscale.max = this.qq.getmax(this.stacked);
        this.ysv.repaint();
        this.doplot();
        if (this.stacked) {
            register.getargs(this).add("stacked");
        } else {
            register.getargs(this).remove("stacked");
        }
    }

    class lineplotmainpan
    extends JPanel
    implements MouseMotionListener {
        JLabel info = new JLabel();

        public lineplotmainpan() {
            this.setLayout(null);
            this.add(this.info);
            this.info.setOpaque(true);
            this.info.setBackground(this.getBackground());
            this.addMouseMotionListener(this);
            this.setCursor(new Cursor(1));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldat = g2.getTransform();
            float xsf = (float)this.getWidth() / lineplot.this.xscale.range();
            float ysf = (float)(-this.getHeight()) / lineplot.this.yscale.range();
            float xyf = xsf / ysf;
            g2.scale(ysf, ysf);
            g2.translate(-lineplot.this.xscale.min() * xyf, -lineplot.this.yscale.max());
            g2.setStroke(new BasicStroke(Math.abs(lineplot.this.yscale.range()) / (float)thin));
            if (lineplot.this.stacked) {
                int xmin = (int)lineplot.this.xscale.min();
                int xmax = (int)lineplot.this.xscale.max();
                int xstep = (int)Math.max((float)lineplot.this.qq.map.values().iterator().next().xstep, lineplot.this.xscale.range() / (float)this.getWidth());
                if (xstep < 1) {
                    xstep = 1;
                }
                int ns = (xmax - xmin) / xstep;
                float[] totpos = new float[1 + ns];
                float[] totneg = new float[1 + ns];
                GeneralPath basepos = new GeneralPath();
                GeneralPath baseneg = new GeneralPath();
                basepos.moveTo((float)xmin * xyf, 0.0f);
                baseneg.moveTo((float)xmin * xyf, 0.0f);
                int x = xmin;
                int i = 0;
                while (x <= xmax) {
                    totpos[i] = 0.0f;
                    totneg[i] = 0.0f;
                    basepos.lineTo((float)x * xyf, 0.0f);
                    baseneg.lineTo((float)x * xyf, 0.0f);
                    x += xstep;
                    ++i;
                }
                boolean even = true;
                for (qt q : lineplot.this.qq.mapwithouttotal().values()) {
                    int i2;
                    if (!q.checkcomplexity()) continue;
                    even = !even;
                    GeneralPath linepos = basepos;
                    GeneralPath lineneg = baseneg;
                    basepos = new GeneralPath();
                    baseneg = new GeneralPath();
                    boolean first = true;
                    int x2 = even ? xmin : xmax;
                    int n = i2 = even ? 0 : ns;
                    while (even ? x2 <= xmax : x2 >= xmin) {
                        if (q.gotdata(x2)) {
                            float dy = q.get(x2);
                            int n2 = i2;
                            totpos[n2] = totpos[n2] + (dy > 0.0f ? dy : 0.0f);
                            int n3 = i2;
                            totneg[n3] = totneg[n3] + (dy < 0.0f ? dy : 0.0f);
                            linepos.lineTo((float)x2 * xyf, totpos[i2]);
                            lineneg.lineTo((float)x2 * xyf, totneg[i2]);
                            if (first) {
                                basepos.moveTo((float)x2 * xyf, totpos[i2]);
                            } else {
                                basepos.lineTo((float)x2 * xyf, totpos[i2]);
                            }
                            if (first) {
                                baseneg.moveTo((float)x2 * xyf, totneg[i2]);
                            } else {
                                baseneg.lineTo((float)x2 * xyf, totneg[i2]);
                            }
                            first = false;
                        }
                        x2 += even ? xstep : -xstep;
                        i2 += even ? 1 : -1;
                    }
                    g2.setColor(q.color);
                    g2.fill(linepos);
                    g2.fill(lineneg);
                }
            } else {
                for (qt q : lineplot.this.qq.map.values()) {
                    if (!q.checkcomplexity()) continue;
                    GeneralPath line = new GeneralPath();
                    boolean haddata = false;
                    int xstep = (int)Math.max((float)q.xstep, lineplot.this.xscale.range() / (float)this.getWidth());
                    if (xstep < 1) {
                        xstep = 1;
                    }
                    for (int x = (int)lineplot.this.xscale.min(); x <= (int)lineplot.this.xscale.max(); x += xstep) {
                        if (!q.gotdata(x)) {
                            haddata = false;
                        }
                        if (q.gotdata(x) && !haddata) {
                            line.moveTo((float)x * xyf, q.get(x));
                            haddata = true;
                        }
                        if (!q.gotdata(x) || !haddata) continue;
                        line.lineTo((float)x * xyf, q.get(x));
                    }
                    g2.setColor(q.color);
                    try {
                        g2.draw(line);
                    }
                    catch (Error e) {
                        System.err.println("line drawing error");
                    }
                }
            }
            g2.setTransform(oldat);
            g2.dispose();
            this.info.repaint();
            lineplot.this.ready = true;
        }

        public void mouseMoved(MouseEvent e) {
            try {
                qt best = null;
                float x = lineplot.this.xscale.min() + lineplot.this.xscale.range() * (float)e.getX() / (float)this.getWidth();
                float y = lineplot.this.yscale.max() - lineplot.this.yscale.range() * (float)e.getY() / (float)this.getHeight();
                if (x > lineplot.this.xscale.min() && x < lineplot.this.xscale.max() && y > lineplot.this.yscale.min() && y < lineplot.this.yscale.max()) {
                    this.info.setText("<html>" + (int)((double)x + 0.5) + "<br>" + lineplot.this.yscale.units.round(y, 2));
                } else {
                    this.info.setText("");
                }
                this.info.setLocation(e.getX() + 4, e.getY() + 4);
                this.info.setSize(this.info.getPreferredSize());
                if (!lineplot.this.stacked) {
                    for (qt q : lineplot.this.qq.map.values()) {
                        if (best != null && !(Math.abs(q.get((int)x) - y) < Math.abs(best.get((int)x) - y))) continue;
                        best = q;
                    }
                    this.setToolTipText(Math.abs(best.get((int)x) - y) < lineplot.this.yscale.range() / 20.0f ? "<html>" + best.hashcolor() + labman.getTitle(best.name) : null);
                }
            }
            catch (Exception ex) {
                System.err.println("lineplot mouse moved exception");
            }
        }

        public void mouseDragged(MouseEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        normal,
        rate,
        ratio,
        difference;

    }
}

