/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import jcm.core.hasinfo;
import jcm.core.infob;
import jcm.core.param;
import jcm.core.qtset;
import jcm.core.register;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.plot.baseplot;
import jcm.gui.plot.scaleview;

public class histoplot
extends baseplot {
    qtset[] sets;
    param year;
    paramValueChooser yc;
    List regs = new ArrayList();
    Comparator comp = new Comparator(){

        public int compare(Object a, Object b) {
            return histoplot.this.calcratio(a, 0) > histoplot.this.calcratio(b, 0) ? 1 : (histoplot.this.calcratio(a, 0) < histoplot.this.calcratio(b, 0) ? -1 : 0);
        }
    };

    public histoplot(Object[] args) {
        int i = 0;
        for (Object o : args) {
            if (!(o instanceof qtset)) continue;
            ++i;
        }
        this.sets = new qtset[i];
        i = 0;
        for (Object o : args) {
            if (!(o instanceof qtset)) continue;
            this.sets[i] = (qtset)o;
            System.err.println(this.sets[i]);
            ++i;
        }
        this.year = new param("year", 2002, this.sets[1].sy, this.sets[1].ey, "year");
        this.yc = new paramValueChooser(this.year, "modview");
        register.addlink(this, this.year);
        for (i = 0; i < this.sets.length; ++i) {
            if (i == 1) continue;
            register.addlink(this, this.sets[i]);
        }
        this.setup(this.sets[1]);
        this.sort();
    }

    void makeplot() {
        this.plot = new histo();
    }

    void setname() {
        this.setName("histoplot: " + this.sets[0].getFullName() + "&per&" + this.sets[1].getFullName());
    }

    public void doplot() {
        this.sort();
        super.repaint();
    }

    void makescales() {
        for (Object o : this.sets[1].mapwithouttotal().keySet()) {
            this.regs.add(o);
        }
        float sum = 0.0f;
        float max = 0.0f;
        for (Object o : this.regs) {
            sum += this.sets[1].reg(o).get((int)this.year.val);
            float f = this.calcratio(o);
            if (!(f > max)) continue;
            max = f;
        }
        this.yscale = new param(new Object[]{param.Type.Yscale, "Yscale", this.sets[0].units + "&per&" + this.sets[1].units, 0, 0, Float.valueOf(max)});
        this.ysv = new scaleview(this.yscale);
        this.ysv.setPreferredSize(new Dimension(100, 400));
        this.xscale = new param(new Object[]{param.Type.Xscale, "Xscale", this.sets[1].units, 0, 0, Float.valueOf(sum)});
        this.xsv = new scaleview(this.xscale);
        register.addlink(this, this.xscale, this.yscale);
    }

    void setlayout() {
        super.setlayout();
        this.plot.add((Component)this.yc, "North");
    }

    float calcratio(Object o, int i) {
        float fr = this.sets[1].reg(o).get((int)this.year.val);
        if (fr <= 0.0f) {
            return 0.0f;
        }
        return this.sets[i].reg(o).get((int)this.year.val) / fr;
    }

    float calcratio(Object o) {
        float fr = this.sets[1].reg(o).get((int)this.year.val);
        if (fr <= 0.0f) {
            return 0.0f;
        }
        float f = 0.0f;
        for (int i = 0; i < this.sets.length; ++i) {
            if (i == 1) continue;
            f += this.sets[i].reg(o).get((int)this.year.val);
        }
        return f / fr;
    }

    void sort() {
        Collections.sort(this.regs, this.comp);
    }

    class histo
    extends JPanel
    implements MouseMotionListener {
        public histo() {
            this.addMouseMotionListener(this);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int w = this.getSize().width;
            int h = this.getSize().height;
            float xx = -histoplot.this.xscale.min() * (float)w / histoplot.this.xscale.range();
            for (Object o : histoplot.this.regs) {
                if (o instanceof hasinfo) {
                    g.setColor(((hasinfo)o).getColor());
                }
                float x = histoplot.this.sets[1].reg(o).get((int)histoplot.this.year.val) * (float)w / histoplot.this.xscale.range();
                float yy = h;
                for (int i = 0; i < histoplot.this.sets.length; ++i) {
                    if (i == 1) continue;
                    float y = (int)(histoplot.this.calcratio(o, i) * (float)h / histoplot.this.yscale.max());
                    if (y < 0.0f) {
                        g.setColor(Color.white);
                        g.fillRect((int)xx + 1, (int)yy + 1, (int)x - 2, (int)(-y) - 1);
                    } else {
                        g.fillRect((int)xx, (int)(yy - y) - 1, (int)x, (int)y - 1);
                    }
                    g.setColor(histoplot.this.variant(g.getColor()));
                    yy -= y;
                }
                xx += x;
            }
            histoplot.this.ready = true;
        }

        public void mouseMoved(MouseEvent e) {
            float xx = 0.0f;
            for (Object o : histoplot.this.regs) {
                float x = histoplot.this.sets[1].reg(o).get((int)histoplot.this.year.val) * (float)this.getSize().width / histoplot.this.xscale.max();
                if (xx + x > (float)e.getX() && o instanceof infob) {
                    this.setToolTipText("<html>" + ((infob)o).hashcolor() + ((infob)o).getName() + " " + histoplot.this.calcratio(o, 0) + (histoplot.this.sets.length > 2 ? " " + histoplot.this.calcratio(o, 2) : ""));
                    return;
                }
                xx += x;
            }
        }

        public void mouseDragged(MouseEvent e) {
        }
    }
}

