/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import jcm.core.param;
import jcm.core.plotlink;
import jcm.core.register;
import jcm.core.units;
import jcm.gui.gen.colfont;
import jcm.mod.reg.mapdata;
import jcm.mod.reg.regcli;
import jcm.mod.reg.region;

public class colorscale
extends JPanel
implements colfont,
plotlink {
    public param rescale = new param(new Object[]{"rescale"});
    regcli rc;
    double min;
    double range;
    int r;
    int g;
    int b;
    public static Color[] c = new Color[256];

    public colorscale(regcli rc) {
        this.rc = rc;
        this.setdata(rc.d1);
        register.addlink(this, this.rescale);
    }

    public void setdata(mapdata md) {
        this.makecolors();
        this.autosetminandrange(md);
        this.setBackground(white);
        this.setPreferredSize(new Dimension(400, 32));
    }

    public void doplot() {
        this.autosetminandrange(this.rc.d1);
    }

    public void makecolors() {
        for (int i = 0; i < 256; ++i) {
            this.b = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 43) / 256.0));
            this.g = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 128) / 256.0));
            this.r = (int)(127.0 + 127.0 * Math.cos(Math.PI * 2 * (double)(i - 213) / 256.0));
            colorscale.c[i] = new Color(this.r, this.g, this.b);
        }
    }

    public void autosetminandrange(mapdata d) {
        this.setminandrange(d.fac * (d.av - 2.0 * d.sd), d.fac * (6.0 * d.sd));
    }

    public void setminandrange(double m, double r) {
        this.min = m;
        this.range = r;
    }

    public Color getcolor(float f) {
        if (f <= -999.0f) {
            return white;
        }
        int q = (int)(256.0 * ((double)f - this.min) / this.range + 4096.0) % 256;
        if (q > 0) {
            return c[q];
        }
        return white;
    }

    public Color getcolor(int i) {
        if (this.rc.quantity.chosen.equals("mix&tmx&tmn&pre")) {
            return this.mixcolor(i);
        }
        return this.getcolor(this.rc.d1.r[i]);
    }

    public Color mixcolor(int i) {
        return this.mixcolor(this.rc.d1, this.rc.d2, this.rc.d3, this.rc.d1.r[i], this.rc.d2.r[i], this.rc.d3.r[i]);
    }

    public Color mixregcolor(region r) {
        return this.mixcolor(this.rc.d1, this.rc.d2, this.rc.d3, r.avg(this.rc.d1), r.avg(this.rc.d2), r.avg(this.rc.d3));
    }

    public Color mixcolor(mapdata d1, mapdata d2, mapdata d3, float v, float v2, float v3) {
        int b;
        int g;
        if (v <= -999.0f || v2 <= -999.0f || v3 <= -999.0f) {
            return Color.white;
        }
        int r = (int)(((double)v - (d1.av - 2.0 * d1.sd)) * (128.0 / (2.0 * d1.sd)));
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if ((g = (int)(Math.log(1.0 + ((double)v2 - d2.min) / (d2.av - d2.min)) * 256.0 / Math.log(1.0 + (3.0 * d2.av - d2.min) / (d2.av - d2.min)))) < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if ((b = (int)((d3.av + 2.0 * d3.sd - (double)v3) * (128.0 / (2.0 * d3.sd)))) < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int bw = 16;
        int w = this.getSize().width - 2 * bw;
        int h = this.getSize().height;
        for (int x = bw; x <= w + bw; ++x) {
            float f = (float)(this.min + (double)(x - bw) * this.range / (double)w);
            g.setColor(this.getcolor(f));
            g.drawLine(x, 0, x, h / 2);
            if (x != bw && (x - bw) % (w / (w / 80)) != 0) continue;
            g.setColor(black);
            g.drawLine(x, h / 2, x, h / 2 + 4);
            g.drawString(units.round(f, 1.0, 2), x - 12, h - 4);
        }
    }
}

