/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.core.plotlink;
import jcm.core.qtset;
import jcm.core.register;
import jcm.gui.gen.contextMenu;
import jcm.gui.gen.imagesaver;
import jcm.gui.nav.menuFiller;
import jcm.gui.plot.legend;
import jcm.gui.plot.scaleview;

public class baseplot
extends JPanel
implements plotlink,
menuFiller {
    JPanel plot;
    legend legend;
    contextMenu popup;
    public param xscale;
    public param yscale;
    scaleview xsv;
    scaleview ysv;
    static boolean bigfont = false;
    qtset qq;
    boolean ready = false;
    boolean temporaryqq = false;
    int ow = 0;

    void setup(qtset qq) {
        this.qq = qq;
        register.addlink(this, qq);
        loop.go();
        this.setname();
        this.makescales();
        this.legend = new legend(qq);
        this.makeplot();
        this.setlayout();
        this.setcolor();
        this.setToolTipText(this.getName());
        new contextMenu(this.plot, this, qq);
        this.show();
    }

    void makeplot() {
    }

    void setname() {
        this.setName(this.qq.getLongTitle());
    }

    public void fillMenu(JPopupMenu popup) {
        popup.add(imagesaver.copyaction(this));
        popup.add(imagesaver.saveimagemenu(this, this.qq.name));
    }

    void makescales() {
        this.yscale = this.qq.getyscale();
        this.xscale = this.qq.getxscale();
        this.ysv = new scaleview(this.yscale);
        this.xsv = new scaleview(this.xscale);
        register.addlink(this, this.xscale, this.yscale);
    }

    public void doplot() {
        if (this.ready) {
            this.plot.repaint();
        }
        if (this.ready) {
            this.legend.makelabs();
        }
    }

    public boolean isShowing() {
        return !this.ready || super.isShowing();
    }

    void setlayout() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(g);
        this.ysv.setMinimumSize(new Dimension(40, 0));
        this.xsv.setMinimumSize(new Dimension(0, 20));
        this.legend.setMinimumSize(new Dimension(40, 0));
        this.plot.setMinimumSize(new Dimension(60, 60));
        this.plot.setPreferredSize(new Dimension(200, 200));
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 1.0;
        g.setConstraints(this.ysv, c);
        this.add(this.ysv);
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        g.setConstraints(this.plot, c);
        this.add(this.plot);
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        g.setConstraints(this.legend, c);
        this.add(this.legend);
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        g.setConstraints(this.xsv, c);
        this.add(this.xsv);
    }

    public void repaint() {
        super.repaint();
        int w = this.getSize().width;
        if (w > 500 && this.ow <= 500) {
            this.legend.expand();
        }
        if (w <= 400 && this.ow > 400) {
            this.legend.contract();
        }
        this.ow = w;
    }

    public void removeNotify() {
        super.removeNotify();
        this.xscale.dispose();
        this.yscale.dispose();
        if (this.temporaryqq) {
            this.qq.dispose();
        }
        loop.go();
    }

    void setcolor() {
        Color bcol = Color.white;
        if (this.qq.owner instanceof module) {
            bcol = this.brighter(((module)this.qq.owner).world.color);
        }
        this.setBackground(bcol);
        this.plot.setBackground(bcol);
        this.ysv.setBackground(bcol);
        this.xsv.setBackground(bcol);
        this.legend.setBackground(bcol);
    }

    Color brighter(Color c) {
        if (c == Color.black) {
            return Color.white;
        }
        return new Color(255 - (255 - c.getRed()) / 8, 255 - (255 - c.getGreen()) / 8, 255 - (255 - c.getBlue()) / 8);
    }

    Color variant(Color c) {
        return new Color(this.vary(c.getRed()), this.vary(c.getGreen()), this.vary(c.getBlue()));
    }

    int vary(int c) {
        if (c < 127) {
            return (int)((double)c * 1.5);
        }
        return (int)((double)c * 0.67);
    }
}

