/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jcm.core.complexity;
import jcm.core.infob;
import jcm.core.loop;
import jcm.core.param;
import jcm.core.plotlink;
import jcm.core.register;
import jcm.core.world;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.contextMenu;
import jcm.gui.gen.imagesaver;
import jcm.gui.nav.showpan;

public class treeMaker
extends JScrollPane
implements plotlink,
TreeExpansionListener {
    JTree tree;
    jcmTreeModel tm;
    final treeMaker treemaker = this;
    boolean insetup = false;
    boolean firstsetup = true;
    Map<param, TreePath> visparams = new HashMap<param, TreePath>();
    infob io = null;
    infob oldio = null;
    JPopupMenu pop = new JPopupMenu();
    public static param helpmode = new param("helpmode", true);
    public static param filterenabled = new param("filterenabled", true);
    plotlink restruc = new plotlink(){

        public void doplot() {
            if (filterenabled.istrue()) {
                treeMaker.filterenabled.needed = false;
            }
            if (loop.changeinteractions) {
                System.err.println("Tree Refreshed");
                Object[] paths = treeMaker.this.getOpenPaths();
                for (param p : treeMaker.this.visparams.keySet()) {
                    register.removelink(this, p);
                }
                for (TreePath treePath : paths) {
                    if (!treeMaker.this.tree.isVisible(treePath)) continue;
                    treeMaker.this.tree.collapsePath(treePath);
                }
                infob root = treeMaker.this.tm.root;
                treeMaker.this.tm = new jcmTreeModel();
                treeMaker.this.tm.root = root;
                treeMaker.this.tree.setModel(treeMaker.this.tm);
                treeMaker.this.tree.treeDidChange();
                treeMaker.this.expandpaths(paths);
            }
        }

        public boolean isShowing() {
            return treeMaker.this.tree.isShowing();
        }
    };

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (filterenabled.istrue()) {
            treeMaker.filterenabled.changed = true;
        }
    }

    public void doplot() {
        this.tree.treeDidChange();
    }

    public treeMaker(Object arg) {
        this.setup(new Object[]{arg});
    }

    public treeMaker(Object[] args) {
        this.setup(args);
    }

    public treeMaker() {
        this.tm = new jcmTreeModel();
        this.newtree();
        this.setup();
    }

    public void setup(Object[] args) {
        this.tm = new jcmTreeModel();
        this.setroot(args);
        this.newtree();
        this.setup();
        this.expandpaths(args);
    }

    void setroot(Object[] args) {
        if (args.length == 0) {
            this.tm.root = world.worldsob;
        } else {
            infob i;
            String s = args[0].toString().substring(1, args[0].toString().length() - 1);
            infob infob2 = i = s.equals(world.worldsob.name) ? world.worldsob : (infob)world.worldsob.find(s);
            if (i != null) {
                this.tm.root = i;
            }
        }
    }

    void expandpaths(Object[] args) {
        this.insetup = true;
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            for (Object o : args) {
                try {
                    if (!o.toString().equals(this.tree.getPathForRow(row).toString())) continue;
                    this.tree.expandRow(row);
                }
                catch (Exception e) {
                    System.err.println("Exception Expanding Tree Path:  " + o.toString());
                    e.printStackTrace();
                }
            }
        }
        this.insetup = false;
    }

    void setup() {
        this.setPreferredSize(new Dimension(300, 500));
        this.setName(this.tm.root.getName());
        this.setViewportView(this.tree);
        this.setBackground(showpan.mf.getBackground());
        this.tree.setBackground(showpan.mf.getBackground());
        this.tree.setOpaque(false);
        this.setOpaque(false);
        register.addlink(this.restruc, complexity.defaultcomplexity);
        register.addlink(this.restruc, labman.language);
        register.addlink(this.restruc, filterenabled);
    }

    void savesetup() {
        List al = register.getargs(this);
        if (al != null) {
            al.clear();
            for (TreePath o : this.getOpenPaths()) {
                al.add(o);
            }
        }
    }

    public TreePath[] getOpenPaths() {
        ArrayList<TreePath> openPaths = new ArrayList<TreePath>();
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            if (!this.tree.isExpanded(row)) continue;
            openPaths.add(this.tree.getPathForRow(row));
        }
        return openPaths.toArray(new TreePath[0]);
    }

    public void newtree() {
        this.tree = new JTree(this.tm);
        this.tree.setShowsRootHandles(true);
        jcmTreeCellRenderer tcr = new jcmTreeCellRenderer();
        this.tree.setCellRenderer(tcr);
        this.tree.setCellEditor(tcr);
        this.tree.setRowHeight(0);
        tcr.addCellEditorListener(new CellEditorListener(){

            public void editingStopped(ChangeEvent e) {
                System.out.println("edit stopped");
            }

            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.tree.setScrollsOnExpand(true);
        this.tree.setEditable(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setLargeModel(true);
        this.tree.addTreeExpansionListener(this);
        new contextMenu(this.tree, this);
        this.addClickEffect();
        this.tree.addMouseListener(showpan.moulist);
        this.tree.addMouseMotionListener(showpan.moulist);
    }

    void addClickEffect() {
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                Object o;
                TreePath tp = treeMaker.this.tree.getPathForLocation(e.getX(), e.getY());
                if (tp == null) {
                    tp = treeMaker.this.tree.getPathForLocation(e.getX() - 100, e.getY());
                }
                treeMaker.this.io = tp != null ? ((o = tp.getLastPathComponent()) != null && o instanceof infob ? (infob)o : null) : null;
                if (treeMaker.this.oldio != treeMaker.this.io) {
                    treeMaker.this.pop.removeAll();
                    treeMaker.this.pop.setVisible(false);
                    if (treeMaker.this.io != null) {
                        treeMaker.this.io.fillMenu(treeMaker.this.pop);
                    } else if (e.getX() > 100) {
                        treeMaker.this.pop.add(showpan.pan("About&treeMaker", docview.class, "treeMaker"));
                        treeMaker.this.pop.add(imagesaver.copyaction(treeMaker.this.tree));
                        treeMaker.this.pop.add(imagesaver.saveimagemenu(treeMaker.this.tree, "JCMtree"));
                    }
                    if (treeMaker.this.pop.getComponentCount() > 0) {
                        treeMaker.this.pop.show(treeMaker.this.tree, Math.min(e.getX() + 24, treeMaker.this.tree.getWidth()), e.getY() - 16);
                    }
                    treeMaker.this.oldio = treeMaker.this.io;
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                if (!treeMaker.this.tree.contains(e.getPoint())) {
                    treeMaker.this.pop.removeAll();
                    treeMaker.this.pop.setVisible(false);
                }
            }

            public void mouseReleased(MouseEvent e) {
                TreePath tp = treeMaker.this.tree.getPathForLocation(e.getX(), e.getY());
                if (tp != null) {
                    if (treeMaker.this.tree.isExpanded(tp)) {
                        treeMaker.this.tree.collapsePath(tp);
                    } else {
                        treeMaker.this.tree.expandPath(tp);
                    }
                }
                if (helpmode.istrue() && treeMaker.this.io != null) {
                    if (docview.current == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                showpan.makepan(docview.class, treeMaker.this.io.getName(), new Object[0]);
                            }
                        });
                    } else {
                        docview.current.setpage(treeMaker.this.io.getName());
                        showpan.toFront(docview.current);
                    }
                }
            }
        });
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        for (param p : this.visparams.keySet()) {
            if (this.tree.isVisible(this.visparams.get(p)) && this.tree.isExpanded(this.visparams.get(p))) continue;
            register.removelink(this, p);
        }
        if (!this.insetup) {
            this.savesetup();
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.addlinkpath(event.getPath());
        Enumeration<TreePath> e = this.tree.getExpandedDescendants(event.getPath());
        while (e.hasMoreElements()) {
            this.addlinkpath(e.nextElement());
        }
        if (!this.insetup) {
            loop.golater();
        }
        if (!this.insetup) {
            this.savesetup();
        }
    }

    void addlinkpath(TreePath tp) {
        Object oe = tp.getLastPathComponent();
        if (oe instanceof infob) {
            for (Object o : ((infob)oe).getEnabledObs(true, filterenabled.istrue())) {
                if (!(o instanceof param)) continue;
                param p = (param)o;
                register.addlink(this, p);
                this.visparams.put(p, tp);
            }
        }
    }

    public infob getRoot() {
        return this.tm.root;
    }

    class jcmTreeCellRenderer
    implements TreeCellRenderer,
    TreeCellEditor {
        jcmTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return this.getc(value);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            return this.getc(value);
        }

        Component getc(Object value) {
            if (value instanceof infob) {
                return ((infob)value).getComponent("tree");
            }
            if (value instanceof Action) {
                return new JButton((Action)value);
            }
            return new JLabel(value.toString());
        }

        public void removeCellEditorListener(CellEditorListener c) {
        }

        public void addCellEditorListener(CellEditorListener c) {
        }

        public void cancelCellEditing() {
        }

        public boolean stopCellEditing() {
            return true;
        }

        public Object getCellEditorValue() {
            return null;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }
    }

    class jcmTreeModel
    implements TreeModel {
        public infob root = (infob)world.worldsob.find("World 1");

        jcmTreeModel() {
        }

        public Object getChild(Object parent, int index) {
            return ((infob)parent).getEnabledObs(true, filterenabled.istrue()).get(index);
        }

        public int getChildCount(Object parent) {
            if (this.isLeaf(parent)) {
                return 0;
            }
            return ((infob)parent).getEnabledObs(true, filterenabled.istrue()).size();
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((infob)parent).getEnabledObs(true, filterenabled.istrue()).indexOf(child);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node2) {
            return !(node2 instanceof infob) || ((infob)node2).getEnabledObs(true, filterenabled.istrue()) == null;
        }

        public void addTreeModelListener(TreeModelListener l) {
        }

        public void removeTreeModelListener(TreeModelListener l) {
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }
}

