/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.event.ActionEvent;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jcm.core.complexity;
import jcm.core.infob;
import jcm.core.param;
import jcm.core.plotlink;
import jcm.core.register;
import jcm.core.world;
import jcm.gui.doc.labman;
import jcm.gui.doc.sourceview;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.showpan;
import jcm.gui.nav.treeMaker;
import jcm.script.calcscript;

public class menuMaker
extends JMenu
implements plotlink,
MenuListener {
    infob root;
    String filter;

    public void doplot() {
        this.removeAll();
        this.construct();
    }

    public menuMaker(infob th) {
        this.root = th;
        this.filter = null;
        this.construct();
    }

    public menuMaker(infob th, String s) {
        this.root = th;
        this.filter = s;
        this.construct();
    }

    public void construct() {
        String n = this.filter != null ? this.filter : this.root.getLabel();
        this.setText(n);
        this.setIcon(iconFinder.findIcon(n));
        menuMaker.menutreeloop(this.root, this.filter, this);
        if (menuMaker.dependenabled(this.filter)) {
            this.addMenuListener(this);
        }
        if (this.filter != "Source" && this.filter != "Data" && this.filter != "Script") {
            register.addlink(this, complexity.defaultcomplexity);
            register.addlink(this, labman.language);
        }
    }

    static boolean dependenabled(String filter) {
        return filter == "Params" || filter == "Worlds";
    }

    public void menuSelected(MenuEvent e) {
        if (treeMaker.filterenabled.istrue()) {
            this.removeAll();
            this.construct();
        }
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuCanceled(MenuEvent e) {
    }

    static JMenuItem menutreeloop(infob th, String filter) {
        return menuMaker.menutreeloop(th, filter, null);
    }

    public static JMenuItem menutreeloop(infob th, String filter, JMenu m) {
        List Obs = th.getEnabledObs(true, menuMaker.dependenabled(filter) && treeMaker.filterenabled.istrue());
        if (Obs != null || th.actions != null) {
            JMenuItem jmi;
            if (m == null) {
                m = new JMenu(th.getLabel());
                if (m.getIcon() == null) {
                    m.setIcon(th.getIcon());
                }
                m.setForeground(th.getColor());
            }
            if ((jmi = menuMaker.getMenuItem(th, filter)) != null) {
                m.add(jmi);
            }
            if (Obs != null) {
                for (Object o : Obs) {
                    JMenuItem mi;
                    if (!(o instanceof infob) || filter == "Worlds" && !(o instanceof world) || (mi = menuMaker.menutreeloop((infob)o, filter)) == null) continue;
                    m.add(mi);
                }
            }
            if (th instanceof infob && th.actions != null) {
                for (Action a : th.actions) {
                    if (filter == null || filter == "Worlds") {
                        m.add(a);
                        continue;
                    }
                    if (!a.getValue("Name").equals(filter)) continue;
                    JMenuItem m2 = new JMenuItem(a);
                    m2.setIcon(th.getIcon());
                    m.add(m2);
                }
            }
            if (m.getMenuComponentCount() > 1) {
                return m;
            }
            if (m.getMenuComponentCount() == 1) {
                JMenuItem mi = m.getItem(0);
                if (!mi.getText().equals(th.getLabel())) {
                    mi.setText(th.getLabel() + " > " + mi.getText());
                }
                return mi;
            }
        }
        return menuMaker.getMenuItem(th, filter);
    }

    static JMenuItem getMenuItem(infob th, String filter) {
        if (filter == "Script" || filter == "Source") {
            return menuMaker.sslink(th, filter);
        }
        if (filter == "Params" && th instanceof param) {
            return ((param)th).getMenuItem();
        }
        if (filter == "Data") {
            String f = world.getPath(th).replace(".", "/");
            int i = f.lastIndexOf("/");
            if (i > 0 && i < f.length()) {
                f = f.substring(0, i) + "." + f.substring(i + 1, f.length());
            }
            return new JMenuItem(showpan.pan(th.getName(), sourceview.class, f));
        }
        return null;
    }

    static JMenuItem sslink(infob th, String filter) {
        String ss = world.getPath(th);
        try {
            final Class<?> c = Class.forName(ss);
            if (filter == "Script" && calcscript.class.isAssignableFrom(c)) {
                return new JMenuItem(new AbstractAction(c.getSimpleName()){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            ((calcscript)c.newInstance()).start();
                        }
                        catch (Exception ex) {
                            System.err.println("Problem Instantiating Script");
                            ex.printStackTrace();
                        }
                    }
                });
            }
            if (filter == "Source" && Modifier.isPublic(c.getModifiers())) {
                return new JMenuItem(showpan.pan(th.getName(), sourceview.class, "source/" + ss.replace(".", "/") + ".java"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

