/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import javax.swing.event.MouseInputListener;
import jcm.core.hasinfo;
import jcm.core.infob;
import jcm.gui.gen.colfont;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.showpan;

public class circmenu
extends JComponent
implements MouseInputListener {
    Object start;
    Area selected;
    boolean paint = true;
    Map<Area, Object> segs = new HashMap<Area, Object>();

    public Collection subItems(Object o) {
        ArrayList<Object> c = new ArrayList<Object>();
        if (o instanceof hasinfo && ((hasinfo)o).getObs() != null) {
            for (Object me : ((hasinfo)o).getObs()) {
                if (this.subItems(me) == null) continue;
                c.add(me);
            }
        }
        if (o instanceof infob && ((infob)o).actions != null) {
            for (Action a : ((infob)o).actions) {
                c.add(a);
            }
        }
        if (c.size() > 0) {
            return c;
        }
        return null;
    }

    public circmenu(Object o) {
        this(o, 0.0f, null);
    }

    public circmenu(Object o, float angle, Object back) {
        this.start = o;
        Dimension d = new Dimension(200, 200);
        this.setSize(d);
        this.setPreferredSize(d);
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setOpaque(false);
        Collection sub = this.subItems(o);
        if (back != null) {
            sub.add(back);
        }
        float step = 360.0f / (float)sub.size();
        float in = 40.0f;
        float out = 100.0f;
        Area inner = new Area(new Arc2D.Float(out - in, out - in, in * 2.0f, in * 2.0f, 0.0f, 360.0f, 2));
        this.segs.put(inner, o);
        for (Object me : sub) {
            Area pie = new Area(new Arc2D.Float(0.0f, 0.0f, out * 2.0f, out * 2.0f, angle, step, 2));
            pie.subtract(inner);
            this.segs.put(pie, me);
            angle += step;
        }
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.paint) {
            for (Area a : this.segs.keySet()) {
                String s;
                Object o = this.segs.get(a);
                Color c = o instanceof hasinfo ? ((hasinfo)o).getColor() : infob.rcol();
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
                g2.setColor(this.selected == a ? c.brighter() : c);
                g2.fill(a);
                g2.setFont(colfont.bigbold);
                g2.setColor(colfont.black);
                Rectangle r = a.getBounds();
                String string = o instanceof infob ? ((infob)o).getLabel() : (s = o instanceof Action ? ((Action)o).getValue("Name").toString() : o.toString());
                if (iconFinder.findIcon(s) != null) {
                    iconFinder.findIcon(s).paintIcon(this, g, r.x + r.width / 2 - 10, r.y + r.height / 2);
                }
                g2.drawString(s, r.x + r.width / 2 - 20, r.y + r.height / 2 - 5);
            }
        }
    }

    Color subcol(Color c, float f) {
        return new Color(this.rand(c.getRed(), f), this.rand(c.getGreen(), f), this.rand(c.getBlue(), f));
    }

    int rand(int x, float f) {
        return (int)((double)x + (double)(255 - x) * Math.random() / (double)f - (double)x * Math.random() / (double)f);
    }

    public void mouseClicked(MouseEvent e) {
        for (Area a : this.segs.keySet()) {
            JComponent newc;
            if (!a.contains(e.getPoint())) continue;
            Object o = this.segs.get(a);
            Container c = this.getRootPane().getParent();
            Point p = c instanceof WindowConstants ? this.getLocation() : c.getLocation();
            int mx = e.getPoint().x - this.getSize().width / 2;
            int my = e.getPoint().y - this.getSize().height / 2;
            final Point z = new Point(p.x + mx, p.y + my);
            float angle = (float)((Math.atan((float)my / (float)mx) * 180.0 / Math.PI + (double)(mx < 0 ? 180 : 360)) % 360.0);
            JComponent jComponent = this.subItems(o) != null && this.subItems(o).size() > 0 ? new circmenu(this.segs.get(a), angle, this.start) : (o instanceof hasinfo ? ((hasinfo)o).getComponent(new Object[0]) : (newc = o instanceof JComponent ? (JComponent)o : null));
            if (newc != null) {
                this.paint = false;
                this.getRootPane().repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        newc.setSize(newc.getPreferredSize());
                        showpan.addwindow(newc, z);
                        circmenu.this.close();
                    }
                });
            }
            if (!(o instanceof Action)) continue;
            ((Action)o).actionPerformed(new ActionEvent(this, 0, null));
            this.close();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.close();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        for (Area a : this.segs.keySet()) {
            if (!a.contains(e.getPoint()) || this.selected == a) continue;
            this.selected = a;
            this.repaint();
            return;
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    void close() {
        Container c = this.getRootPane().getParent();
        if (c instanceof WindowConstants) {
            c = this.getParent();
            c.remove(this);
            c.repaint();
        } else {
            ((Window)c).hide();
            ((Window)c).dispose();
        }
    }
}

