/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import jcm.core.interacob;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.qtset;
import jcm.core.register;
import jcm.gui.gen.colfont;

public class interacmap
extends JPanel
implements Runnable {
    Map<interacob, node> map = new HashMap<interacob, node>();
    int z = 1000;
    boolean running = false;
    node centre = new node();
    static interacmap cfc;
    float fg = 70000.0f;
    int nstep = 0;
    Font bold = new Font("Arial", 1, 16);
    Font plain = new Font("Arial", 0, 12);
    Font italic = new Font("Arial", 2, 12);

    public interacmap() {
        this.setName("JCM Interactions");
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(600, 600));
        cfc = this;
        this.add(new JButton(new AbstractAction("start"){

            public void actionPerformed(ActionEvent e) {
                interacmap.this.running = true;
                new Thread(cfc).start();
            }
        }));
        this.add(new JButton(new AbstractAction("stop"){

            public void actionPerformed(ActionEvent e) {
                interacmap.this.running = false;
            }
        }));
        this.add(new JButton(new AbstractAction("step"){

            public void actionPerformed(ActionEvent e) {
                interacmap.this.step();
                interacmap.this.repaint();
            }
        }));
        this.add(new JButton(new AbstractAction("loop-go"){

            public void actionPerformed(ActionEvent e) {
                loop.go();
            }
        }));
        loop.go();
    }

    public void removeNotify() {
        this.running = false;
        if (cfc == this) {
            cfc = null;
        }
    }

    public void hide() {
        if (cfc == this) {
            cfc = null;
        }
        super.hide();
    }

    public void show() {
        cfc = this;
        super.show();
    }

    public static void reset() {
        if (cfc != null) {
            System.out.println("reset flowchart");
            interacmap.cfc.running = false;
            cfc.setup();
            cfc.step();
            cfc.repaint();
        }
    }

    public void setup() {
        for (interacob i : register.alliobs) {
            if (this.map.containsKey(i)) continue;
            this.map.put(i, new node(i));
        }
        Iterator<interacob> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            interacob i;
            i = it.next();
            if (i != null && !i.disposed) continue;
            it.remove();
        }
    }

    public void run() {
        while (this.running) {
            this.step();
            ++this.nstep;
            this.nstep %= 50;
            if (this.nstep != 0) continue;
            this.repaint();
        }
    }

    void step() {
        for (node n : this.map.values()) {
            n.random(50 - this.nstep);
        }
        for (node n : this.map.values()) {
            for (interacob i : n.i.vaffectedby) {
                node m = this.map.get(i);
                if (m == null) continue;
                n.pull(m, 2.0f);
            }
        }
        for (node n : this.map.values()) {
            for (node m : this.map.values()) {
                if (n == m) continue;
                n.push(m, 1000.0f);
            }
        }
        for (node n : this.map.values()) {
            n.edgepush(this.fg);
        }
        for (node n : this.map.values()) {
            n.move(100.0f);
        }
        for (node n : this.map.values()) {
            n.edge();
        }
        float g = 0.0f;
        for (node n : this.map.values()) {
            g += n.dist(this.centre);
        }
        this.fg += 10000.0f * ((g /= (float)this.map.size()) - 350.0f) / 350.0f;
    }

    public void paintComponent(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        super.paintComponent(g);
        for (node n : this.map.values()) {
            for (interacob i : n.i.vaffectedby) {
                node m = this.map.get(i);
                if (m == null) continue;
                if (n.i.affects(m.i)) {
                    g.setColor(colfont.orange);
                    g.drawLine(n.x * w / this.z, n.y * h / this.z, m.x * w / this.z, m.y * h / this.z);
                    continue;
                }
                int x2 = (n.x + m.x) * w / (this.z * 2);
                int y2 = (n.y + m.y) * h / (this.z * 2);
                g.setColor(colfont.red);
                g.drawLine(n.x * w / this.z, n.y * h / this.z, x2, y2);
                g.setColor(colfont.yellow);
                g.drawLine(x2, y2, m.x * w / this.z, m.y * h / this.z);
            }
        }
        for (node n : this.map.values()) {
            String s = n.i.name;
            if (n.i instanceof module) {
                s = ((module)n.i).order + " " + s;
            }
            g.setFont(n.i instanceof module ? this.bold : (n.i instanceof qtset ? this.italic : this.plain));
            g.setColor(n.i.output ? (n.i.changed ? colfont.magenta : colfont.red) : (n.i.needed ? (n.i.changed ? colfont.cyan : colfont.green) : (n.i.changed ? colfont.ltblue : colfont.grey)));
            g.drawString(s, n.x * w / this.z, n.y * h / this.z);
        }
    }

    class node {
        float dx;
        float dy;
        int x;
        int y;
        interacob i;

        node(interacob i) {
            this.i = i;
            this.x = (int)((double)interacmap.this.z * Math.random());
            this.y = (int)((double)interacmap.this.z * Math.random());
            this.dx = 0.0f;
            this.dy = 0.0f;
        }

        node() {
            this.x = interacmap.this.z / 2;
            this.y = interacmap.this.z / 2;
            this.dx = 0.0f;
            this.dy = 0.0f;
        }

        float dist(node m) {
            return (float)Math.sqrt((m.x - this.x) * (m.x - this.x) + (m.y - this.y) * (m.y - this.y));
        }

        void pull(node m, float f) {
            this.dx += f * (float)(m.x - this.x);
            m.dx -= f * (float)(m.x - this.x);
            this.dy += f * (float)(m.y - this.y);
            m.dy -= f * (float)(m.y - this.y);
        }

        void push(node m, float f) {
            float d = (m.x - this.x) * (m.x - this.x) + (m.y - this.y) * (m.y - this.y);
            if (d > 0.0f) {
                this.dx -= f / d * (float)(m.x - this.x);
                m.dx += f / d * (float)(m.x - this.x);
                this.dy -= f / d * (float)(m.y - this.y);
                m.dy += f / d * (float)(m.y - this.y);
            }
        }

        void random(float f) {
            this.x = (int)((float)this.x + (float)((double)f * (Math.random() - 0.5)));
            this.y = (int)((float)this.y + (float)((double)f * (Math.random() - 0.5)));
        }

        void edgepush(float f) {
            if (this.x < interacmap.this.z / 2 && this.x > 0) {
                this.dx += f / (float)this.x;
            }
            if (this.x > interacmap.this.z / 2 && this.x < interacmap.this.z) {
                this.dx -= f / (float)(interacmap.this.z - this.x);
            }
            if (this.y < interacmap.this.z / 2 && this.y > 0) {
                this.dy += f / (float)this.y;
            }
            if (this.y > interacmap.this.z / 2 && this.y < interacmap.this.z) {
                this.dy -= f / (float)(interacmap.this.z - this.y);
            }
        }

        void edge() {
            int d = 20;
            int d2 = 20;
            if (this.x < d) {
                this.x = d;
            }
            if (this.x > interacmap.this.z - d) {
                this.x = interacmap.this.z - d;
            }
            if (this.y < d + d2) {
                this.y = d + d2;
            }
            if (this.y > interacmap.this.z - d + d2) {
                this.y = interacmap.this.z - d + d2;
            }
        }

        void move(float f) {
            this.x = (int)((float)this.x + this.dx / f);
            this.y = (int)((float)this.y + this.dy / f);
            this.dx /= 2.0f;
            this.dy /= 2.0f;
        }
    }
}

