/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import jcm.tls.fileio;

public class imagesaver {
    public static Action copyaction(final Component painter) {
        return new AbstractAction("Copy image"){

            public void actionPerformed(ActionEvent e) {
                imagesaver.copy(painter);
            }
        };
    }

    public static JMenu saveimagemenu(final Component painter, final String name) {
        JMenu saveimage = new JMenu("Save image");
        for (final String s : new String[]{"png", "png-transparent", "jpg"}) {
            saveimage.add(new AbstractAction(s){

                public void actionPerformed(ActionEvent e) {
                    imagesaver.saveimage(painter, name, s);
                }
            });
        }
        return saveimage;
    }

    static BufferedImage getimage(Component c, boolean transparent) {
        BufferedImage bi = new BufferedImage(c.getSize().width, c.getSize().height, 6);
        c.paint(bi.getGraphics());
        return transparent ? imagesaver.maketrans(bi) : bi;
    }

    static BufferedImage maketrans(BufferedImage bi) {
        try {
            BufferedImage bi2 = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
            int mask = bi.getRGB(0, 0);
            for (int x = 0; x < bi.getWidth(); ++x) {
                for (int y = 0; y < bi.getHeight(); ++y) {
                    bi2.setRGB(x, y, bi.getRGB(x, y) == mask ? 0 : bi.getRGB(x, y));
                }
            }
            return bi2;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void saveimage(Component painter, String name, String type) {
        imagesaver.saveimage(painter, type, fileio.getFileFromDialog(painter, "user", name + "." + type, "Save image", "save"));
    }

    public static void saveimage(Component painter, String type, File f) {
        if (f != null) {
            try {
                boolean transparent = type.endsWith("transparent");
                ImageIO.write((RenderedImage)imagesaver.getimage(painter, transparent), type.substring(0, 3), f);
                System.out.println("saved image: " + f);
            }
            catch (Exception ex) {
                System.out.println("Error in saving image file");
            }
        }
    }

    public static void copy(final Component c) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new Transferable(){

                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.imageFlavor};
                }

                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.equals(DataFlavor.imageFlavor);
                }

                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    return imagesaver.getimage(c, false);
                }
            }, new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
            System.out.println("copied image");
        }
        catch (Exception ex) {
            System.out.println("Error copying");
        }
    }
}

