/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jcm.core.complexity;
import jcm.core.hasinfo;
import jcm.core.infob;
import jcm.core.interacob;
import jcm.core.loop;
import jcm.core.module;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.showpan;
import jcm.gui.nav.treeMaker;
import jcm.mod.data.loaddata;
import jcm.tls.fileio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class world
extends infob {
    public static List<world> worlds = new LinkedList<world>();
    public static infob root = new infob("JCM5");
    public static infob worldsob = new infob("Worlds");
    public static Set<String> packages = new HashSet<String>();
    static Icon wi = iconFinder.findIcon("world");
    public List<module> mods = new LinkedList<module>();
    Map<Class, module> modmap = new LinkedHashMap<Class, module>();

    public world(String worldname) {
        this.name = worldname;
        if (this.name == "World 1") {
            this.color = Color.black;
        }
        worlds.add(this);
        worldsob.addOb(this);
        root.addOb(this);
        this.obs = ((infob)this.worldtree((hasinfo)((infob)world.root.find((String)"jcm.mod")))).obs;
        loaddata.getdata(this);
        for (module mod : this.mods) {
            System.out.println("setting up mod: " + mod);
            mod.initsetup();
            mod.register();
        }
        this.addAction(new AbstractAction("Remove World", wi){

            public void actionPerformed(ActionEvent e) {
                world.this.dispose();
            }
        });
        this.addAction(new AbstractAction("Change World Name", wi){

            public void actionPerformed(ActionEvent e) {
                world.this.name = JOptionPane.showInputDialog(null, (Object)("Enter new name for " + world.this.name));
            }
        });
        this.addTreeAction();
        this.addDocAction();
    }

    public static Action addWorld() {
        return new AbstractAction("Add World", wi){

            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(null, (Object)"Enter name for new world ");
                new world(name);
                showpan.makepan(treeMaker.class, "[" + name + "]", wi);
                complexity.defaultcomplexity.changed = true;
                loop.go();
            }
        };
    }

    public void dispose() {
        this.dispose(this);
        world.worldsob.obs.remove(this);
        world.root.obs.remove(this);
        worlds.remove(this);
        loop.go();
        complexity.defaultcomplexity.changed = true;
        loop.go();
    }

    void dispose(infob o) {
        if (o.obs != null) {
            for (Object oo : o.obs) {
                if (!(oo instanceof infob)) continue;
                this.dispose((infob)oo);
            }
        }
        if (o instanceof interacob) {
            ((interacob)o).dispose();
        }
    }

    void setmodorder() {
        boolean changed = false;
        int nit = 0;
        do {
            changed = false;
            ++nit;
            for (module m : this.mods) {
                for (module mf : m.follows) {
                    if (m.order > mf.order) continue;
                    m.order = mf.order + 1;
                    changed = true;
                }
            }
        } while (changed && nit <= 100);
        if (nit > 100) {
            System.err.println("Circular module dependencies! ");
        }
        Collections.sort(this.mods);
    }

    public world get(String name) {
        for (world w : worlds) {
            if (!w.name.equals(name)) continue;
            return w;
        }
        return null;
    }

    public <T extends module> T get(Class<T> c) {
        return (T)this.modmap.get(c);
    }

    public hasinfo worldtree(hasinfo orig) {
        Object mod;
        if (orig.getObs() != null) {
            infob copy = new infob(orig.getName(), orig instanceof infob ? ((infob)orig).color : infob.rcol(), ((infob)orig).priority);
            copy.addDocAction();
            copy.addTreeAction();
            for (Object o : orig.getObs()) {
                if (o instanceof hasinfo) {
                    hasinfo hh = this.worldtree((hasinfo)o);
                    if (hh != null && (hh instanceof module || hh.getObs() != null && hh.getObs().size() > 0)) {
                        copy.addOb(hh);
                    }
                    if (!(hh instanceof module)) continue;
                    ((module)hh).color = copy.color;
                    continue;
                }
                copy.addOb(o);
            }
            copy.mincomplexity();
            return copy;
        }
        String ss = world.getPath(orig);
        try {
            mod = this.get(Class.forName(ss));
            if (mod != null) {
                return mod;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass(ss);
            if (module.class.isAssignableFrom(c)) {
                mod = (module)c.newInstance();
                ((module)mod).world = this;
                ((infob)mod).checkinfo();
                this.mods.add((module)mod);
                this.modmap.put(mod.getClass(), (module)mod);
                return mod;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getPath(hasinfo th) {
        String ss = th.getName();
        return ss;
    }

    public static void makeroot() {
        Enumeration<JarEntry> jes = fileio.getJarEntries(world.class.getResource("/jcm/StartJCM.class"));
        while (jes.hasMoreElements()) {
            JarEntry je = jes.nextElement();
            String s = je.getName();
            if (je.isDirectory()) {
                packages.add(s.replace("/", "."));
                System.out.println("unapacking " + s);
            }
            if (je.isDirectory() || je.getName().contains("$")) continue;
            world.addtree(root, s);
        }
        worldsob.addAction(world.addWorld());
        worldsob.addTreeAction();
        worldsob.addDocAction();
        world.root.color = Color.black;
    }

    public static void addtree(hasinfo th, String s) {
        if (s.startsWith("png")) {
            return;
        }
        int i = s.indexOf("/");
        if (i > 0) {
            String s1 = s.substring(0, i);
            String s2 = s.substring(i + 1);
            if (th.getObs() != null) {
                for (Object o : th.getObs()) {
                    if (!(o instanceof hasinfo) || !((hasinfo)o).getName().equals(s1)) continue;
                    world.addtree((hasinfo)o, s1 + "." + s2);
                    return;
                }
            }
            infob hh = new infob(s1, th);
            world.addtree(hh, s1 + "." + s2);
            if (hh.getObs() != null) {
                ((infob)th).addOb(hh);
            }
            return;
        }
        ((infob)th).addOb(new infob(s.replace(".class", ""), th));
    }
}

