/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

public class units {
    public String units;
    public double scales;
    public double scaleu;
    static String[] qs = new String[]{"femto", "pico", "nano", "micro", "milli", "###", "kilo", "mega", "giga", "tera", "peta", "exa", "kiloexa"};
    static int[] qi = new int[]{-15, -12, -9, -6, -3, 0, 3, 6, 9, 12, 15, 18, 21};

    public units(String s) {
        this(s, 1.0);
    }

    public units(String s, double d) {
        this(s, d, 1.0);
    }

    public units(String s, double a, double b) {
        this.units = s;
        this.scales = a;
        this.scaleu = b;
    }

    public void checkunitfac(double range) {
        this.scales = Math.pow(10.0, Math.floor(Math.log(range) / Math.log(10.0) - 0.3));
        if (this.units != "") {
            int oou = 5;
            int fac = 5;
            for (int i = 0; i < qs.length; ++i) {
                if (!this.units.startsWith(qs[i])) continue;
                oou = i;
            }
            int ou = oou - (int)(Math.log(this.scaleu) / Math.log(1000.0));
            for (int i = 0; i < qi.length; ++i) {
                if (!(this.scales >= Math.pow(10.0, qi[i]))) continue;
                fac = i;
            }
            this.scaleu = Math.pow(10.0, qi[fac]);
            int nu = ou + fac - 5;
            this.units = (nu == 5 ? "" : qs[nu]) + this.units.substring(oou == 5 ? 0 : qs[oou].length());
        }
    }

    public void checkunitcancel() {
        int k;
        int j;
        int i = this.units.indexOf("&per&yr");
        if (i > 0 && (j = this.units.indexOf("&per&yr", i + 1)) > 0) {
            this.units = this.units.substring(0, i) + this.units.substring(i + 5, j) + this.units.substring(j + 5);
        }
        int p = this.units.length();
        int pp = -1;
        for (j = 0; j < qs.length; ++j) {
            k = this.units.indexOf(qs[j]);
            if (k <= -1 || k >= p) continue;
            p = k;
            pp = j;
        }
        if (p < this.units.length()) {
            int r;
            int q = -1;
            int qq = -1;
            for (j = 0; j < qs.length; ++j) {
                k = this.units.indexOf(qs[j], p + 1);
                if (k <= q) continue;
                q = k;
                qq = j;
            }
            if (q > -1 && (r = 5 + pp - qq) > -1 && r < qs.length) {
                String newfac = qs[r] + "&";
                if (newfac.equals("###&")) {
                    newfac = "";
                }
                this.units = this.units.substring(0, p) + newfac + this.units.substring(p + qs[pp].length() + 1, q) + this.units.substring(q + qs[qq].length() + 1);
            }
        }
    }

    public String round(double v) {
        return jcm.core.units.round(v, this.scaleu, 1);
    }

    public String round(double v, int dp) {
        return jcm.core.units.round(v, this.scaleu, dp);
    }

    public double unround(double v) {
        return v * this.scaleu;
    }

    public static String round(double v, double u, int dp) {
        int d = (int)Math.pow(10.0, dp);
        if ((double)((int)(v / u)) == v / u) {
            return String.valueOf((int)(v / u));
        }
        return String.valueOf((double)((int)((v >= 0.0 ? 1.0 : -1.0) * 1.0E-7 + (double)d * v / u)) / (double)d);
    }

    public double minstep(double min) {
        return this.scales * (double)((int)(0.8 + min / this.scales));
    }
}

