/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import jcm.core.complexity;
import jcm.core.hasinfo;
import jcm.core.interacob;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.core.plotlink;
import jcm.core.qt;
import jcm.core.register;
import jcm.core.time;
import jcm.core.world;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.menuFiller;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.histoplot;
import jcm.gui.plot.lineplot;
import jcm.gui.plot.scatterplot;
import jcm.mod.reg.regman;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class qtset
extends interacob
implements time,
plotlink,
menuFiller {
    public Map<Object, qt> map = new LinkedHashMap<Object, qt>();
    public qt total = null;
    public qt current = null;
    public int sy = 1750;
    public int ey = 2400;
    public int xstep = 1;
    public String units = "";
    boolean setcomplexity = false;
    boolean setcolor = false;
    public qt.Type type = qt.Type.normal;
    public qtset qqa;
    public qtset qqb;
    Action refresh = new AbstractAction("Refresh Options"){

        public void actionPerformed(ActionEvent e) {
            qtset.this.forcecalc();
            qtset.this.findpotdivby();
        }
    };
    Map<module, Set<qtset>> potdivby;

    public qtset(Object ... args) {
        int sc = 0;
        int ic = 0;
        this.color = null;
        for (Object o : args) {
            if (o instanceof qtset) {
                if (this.qqa == null) {
                    this.qqa = (qtset)o;
                    this.color = this.qqa.color;
                    this.name = this.qqa.name;
                    this.units = this.qqa.units;
                    this.sy = this.qqa.sy;
                    this.ey = this.qqa.ey;
                    this.xstep = this.qqa.xstep;
                } else {
                    this.qqb = (qtset)o;
                }
                this.setaffectedby((interacob)((qtset)o));
            }
            if (o instanceof Color) {
                this.color = (Color)o;
            }
            if (o instanceof interacob) {
                this.owner = (interacob)o;
                this.setaffectedby((interacob)o);
                this.name = this.owner.name;
            }
            if (o instanceof complexity) {
                this.mycomplexity = (complexity)((Object)o);
                this.setcomplexity = true;
            }
            if (o instanceof qt.Type) {
                this.type = (qt.Type)((Object)o);
            }
            if (o instanceof qt[]) {
                for (qt q : (qt[])o) {
                    this.add(q);
                }
            }
            if (o instanceof qt) {
                this.add((qt)o);
            }
            if (o instanceof String) {
                switch (sc) {
                    case 0: {
                        this.name = (String)o;
                        break;
                    }
                    case 1: {
                        this.units = (String)o;
                    }
                }
                ++sc;
            }
            if (!(o instanceof Number)) continue;
            int i = ((Number)o).intValue();
            switch (ic) {
                case 0: {
                    this.sy = i;
                    break;
                }
                case 1: {
                    this.ey = i;
                    break;
                }
                case 2: {
                    this.xstep = i;
                }
            }
            ++ic;
        }
        if (!this.setcomplexity && this.map.size() > 0) {
            this.mincomplexity(this.map.values());
        }
        if (this.color == null) {
            this.color = qtset.rcol(this.owner.color);
        }
        this.addAction(showpan.pan("Plot", lineplot.class, this));
        this.addAction(showpan.pan("Plot %change/yr", lineplot.class, new Object[]{this, "rate"}));
        this.addAction(showpan.pan("Table", datable.class, this));
        this.addDocAction();
    }

    @Override
    public Object find(String name) {
        Object o = super.find(name);
        if (o != null) {
            return o;
        }
        for (Object oo : this.map.keySet()) {
            if (!oo.toString().equals(name)) continue;
            return this.map.get(oo);
        }
        return null;
    }

    public void add(Object o, qt q) {
        this.map.put(o, q);
        if (o == regman.world && q.type == qt.Type.normal) {
            q.type = qt.Type.total;
        }
        if (this.total == null && q.type == qt.Type.total) {
            this.total = q;
        }
        if (!this.setcomplexity) {
            this.mincomplexity(this.map.values());
        }
        q.owner = this;
    }

    public void add(qt ... qq) {
        for (qt q : qq) {
            this.add(q.name, q);
        }
    }

    public qt reg(Object r) {
        if (this.map.containsKey(r)) {
            return this.map.get(r);
        }
        qt q = null;
        switch (this.type) {
            case difference: 
            case sum: 
            case ratio: {
                q = new qt(new Object[]{this.qqa.map.get(r), this.qqb.map.get(r), this.type});
                break;
            }
            default: {
                if (r instanceof hasinfo) {
                    hasinfo ri = (hasinfo)r;
                    q = new qt(ri.getName(), ri.getColor(), this.sy, this.ey, this.xstep, this);
                    break;
                }
                q = new qt(r.toString(), Color.black, this.sy, this.ey, this.xstep, this);
            }
        }
        this.add(r, q);
        return q;
    }

    public float get(Object r, int year) {
        return this.reg(r).get(year);
    }

    public float get(Object r) {
        return this.reg(r).get();
    }

    public float get(int year) {
        return this.current.get(year);
    }

    public float get() {
        return this.current.get();
    }

    public void set(Object r, int year, float f) {
        this.reg(r).set(year, f);
    }

    public void set(int year, float f) {
        this.current.set(year, f);
    }

    public void set(Object r, float f) {
        this.reg(r).set(f);
    }

    public void set(float f) {
        this.current.set(f);
    }

    public void setreg(Object r) {
        this.current = this.reg(r);
    }

    public String getunits() {
        return this.units;
    }

    public param getxscale() {
        return new param(new Object[]{param.Type.Xscale, "Xscale", "year", 0, Math.max(this.sy, 1800), Math.min(this.ey, 2200), 50});
    }

    public param getyscale() {
        return new param(new Object[]{param.Type.Yscale, "Yscale", this.units, 0, Float.valueOf(this.getmin()), Float.valueOf(this.getmax()), 1});
    }

    float getmax() {
        float max = Float.MIN_VALUE;
        for (qt q : this.map.values()) {
            if (!q.checkcomplexity()) continue;
            max = Math.max(max, q.getmax());
        }
        return max;
    }

    float getmin() {
        float min = Float.MAX_VALUE;
        for (qt q : this.map.values()) {
            if (!q.checkcomplexity()) continue;
            min = Math.min(min, q.getmin());
        }
        return min;
    }

    public float getmax(boolean stacked) {
        if (!stacked) {
            return this.getmax();
        }
        float max = Float.MIN_VALUE;
        for (int year = this.sy; year < this.ey; year += this.xstep) {
            float tot = 0.0f;
            for (qt q : this.mapwithouttotal().values()) {
                tot += q.get(year);
            }
            if (!(tot > max)) continue;
            max = tot;
        }
        return max;
    }

    public float calctot() {
        return this.calctot(module.year);
    }

    public float calctot(int year) {
        if (this.total == null) {
            this.total = this.reg(regman.world);
        }
        this.total.set(year, 0.0f);
        for (qt q : this.mapwithouttotal().values()) {
            this.total.set(year, this.total.get(year) + q.get(year));
        }
        return this.total.get(year);
    }

    public Map<Object, qt> mapwithouttotal() {
        LinkedHashMap<Object, qt> m = new LinkedHashMap<Object, qt>();
        for (Map.Entry<Object, qt> me : this.map.entrySet()) {
            if (me.getValue().type == qt.Type.total) continue;
            m.put(me.getKey(), me.getValue());
        }
        return m;
    }

    public qtset combinewith(qtset other, qt.Type type, String name, String units2) {
        qtset cw = new qtset(new Object[]{this, other, type, name, units2});
        for (Object k : this.map.keySet()) {
            if (!other.map.containsKey(k)) continue;
            cw.add(k, new qt(new Object[]{this.map.get(k), other.map.get(k), type}));
        }
        cw.setaffectedby((interacob)this);
        cw.setaffectedby((interacob)other);
        cw.register();
        return cw;
    }

    public qtset divby(qtset other) {
        return this.combinewith(other, qt.Type.ratio, this.name + "&per&" + other.name, this.units + "&per&" + other.units);
    }

    public qtset addto(qtset other) {
        return this.combinewith(other, qt.Type.sum, this.name + "&plus&" + other.name, this.units);
    }

    public qtset subtract(qtset other) {
        return this.combinewith(other, qt.Type.difference, this.name + "&minus&" + other.name, this.units);
    }

    public qtset differentiate() {
        qtset dydx = new qtset(this.name + "&rate", this.units + "&percent&per&year");
        for (Object k : this.map.keySet()) {
            dydx.add(k, new qt(new Object[]{this.map.get(k), qt.Type.rate}));
        }
        dydx.setaffectedby((interacob)this);
        dydx.register();
        dydx.type = qt.Type.rate;
        return dydx;
    }

    @Override
    public String getExtraDoc() {
        return this.docUnits() + this.docCurves() + "----" + this.docInteracs() + autodoc.javacode(this);
    }

    public String docUnits() {
        String s = "==Units==";
        s = s + "units: " + labman.getTitle(this.units) + "<br>";
        s = s + "timescale (years) " + this.sy + "-" + this.ey + " (step " + this.xstep + ")<br>";
        return s;
    }

    /*
     * Unable to fully structure code
     */
    public String docCurves() {
        s = "==Curves==";
        if (this.type == qt.Type.normal) ** GOTO lbl-1000
        if (this.type != qt.Type.total) {
            s = s + labman.getTitle((Object)this.type + "&of&") + this.qqa.docSummary() + "<br>";
        } else if (this.map.size() == 0) {
            s = s + "\u00a3\u00a7nocurvesyet";
        }
        s = s + "<ul>";
        for (qt q : this.map.values()) {
            s = s + "<li>" + q.docSummary();
        }
        s = s + "</ul>";
        return s;
    }

    @Override
    public void fillMenu(JPopupMenu pop) {
        pop.addSeparator();
        super.fillMenu(pop);
        pop.addSeparator();
        if (this.potdivby == null) {
            this.potdivby = new HashMap<module, Set<qtset>>();
            this.findpotdivby();
        }
        if (this.potdivby.size() > 0) {
            pop.add(this.divbymenu(lineplot.class));
            pop.add(this.divbymenu(histoplot.class));
            pop.add(this.divbymenu(scatterplot.class));
        }
        pop.add(this.refresh);
        pop.addSeparator();
        if (world.worlds.size() > 1) {
            pop.add(this.compareworldmenu());
        }
        pop.addSeparator();
        pop.add(datable.savetablemenu(this));
    }

    @Override
    public boolean isShowing() {
        return true;
    }

    @Override
    public void doplot() {
    }

    public void forcecalc() {
        if (this.changed) {
            register.addlink(this, this);
            loop.go();
            register.removelink(this, this);
        }
    }

    void findpotdivby() {
        this.potdivby.clear();
        for (world w : world.worlds) {
            for (module m : w.mods) {
                HashSet<qtset> fit = new HashSet<qtset>();
                block2: for (qtset qqd : m.qtsets) {
                    if (qqd.equals(this)) continue;
                    for (Object o : qqd.map.keySet()) {
                        if (!this.map.containsKey(o)) continue;
                        fit.add(qqd);
                        continue block2;
                    }
                }
                if (fit.size() <= 0) continue;
                this.potdivby.put(m, fit);
            }
        }
    }

    JMenu divbymenu(Class type) {
        JMenu dbm = new JMenu();
        dbm.setText(type.getSimpleName() + " per... ");
        for (module m : this.potdivby.keySet()) {
            JMenu submenu = new JMenu(m.getLongTitle());
            for (qtset qqd : this.potdivby.get(m)) {
                submenu.add(showpan.pan(qqd.getLabel(), type, new Object[]{this, "ratio", qqd}));
            }
            if (submenu.getMenuComponentCount() == 1) {
                dbm.add(submenu.getMenuComponent(0));
                continue;
            }
            dbm.add(submenu);
        }
        return dbm;
    }

    public JMenu compareworldmenu() {
        JMenu cwm = new JMenu(" Compare Worlds... ");
        qtset wq = new qtset(new Object[]{this.name});
        for (final qt q : this.map.values()) {
            cwm.add(new AbstractAction(q.name){

                public void actionPerformed(ActionEvent e) {
                    qtset.this.compareworld(q);
                }
            });
        }
        return cwm;
    }

    void compareworld(qt q) {
        System.err.println(q.name);
        qtset cwq = new qtset(q.name, this.units);
        cwq.register();
        for (world w : world.worlds) {
            for (module m : w.mods) {
                for (qtset mq : m.qtsets) {
                    if (!mq.name.equals(this.name)) continue;
                    cwq.add(w.name, new qt(mq.map.get((Object)q.name).a, w.name, w.color));
                    cwq.setaffectedby((interacob)m);
                }
            }
        }
        showpan.makepan(lineplot.class, cwq, new Object[0]);
    }
}

