/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jcm.core.complexity;
import jcm.core.interacob;
import jcm.core.loop;
import jcm.core.plotlink;
import jcm.core.register;
import jcm.core.units;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.paramMenu;
import jcm.gui.nav.paramOption;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.nav.treeMaker;
import jcm.script.calcscript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class param<T>
extends interacob {
    public Type type;
    public T[] menulist;
    public T chosen;
    public T defchosen;
    public int numitems;
    public Class listtype;
    public boolean flag;
    public boolean defflag;
    public double val;
    public double defval;
    public double max;
    public double min;
    public int dp = 2;
    public units units;
    public param pair;
    public boolean pairof = false;
    public static boolean reportchange = true;

    public param(Object ... args) {
        int dc = 0;
        int sc = 0;
        this.mycomplexity = complexity.normal;
        this.priority = 1.1;
        for (Object a : args) {
            if (a instanceof Object[]) {
                this.type = Type.menu;
                this.listtype = a.getClass().getComponentType();
                this.menulist = (Object[])a;
                this.numitems = this.menulist.length;
                continue;
            }
            if (this.menulist != null && this.chosen == null && this.listtype.isInstance(a)) {
                this.chosen = a;
                this.defchosen = a;
                continue;
            }
            if (a instanceof Type) {
                this.type = (Type)((Object)a);
            }
            if (a instanceof Color) {
                this.color = (Color)a;
            }
            if (a instanceof Boolean) {
                this.defflag = this.flag = ((Boolean)a).booleanValue();
                this.type = Type.option;
            }
            if (a instanceof complexity) {
                this.mycomplexity = (complexity)((Object)a);
            }
            if (a instanceof param) {
                ((param)a).pair = this;
                this.pairof = true;
            }
            if (a instanceof Number) {
                if (this.type == null) {
                    this.type = Type.value;
                }
                double d = ((Number)a).doubleValue();
                if (dc == 0) {
                    this.defval = this.val = d;
                    this.min = Double.MAX_VALUE;
                    this.max = Double.MAX_VALUE;
                }
                if (dc == 1) {
                    this.min = d;
                }
                if (dc == 2) {
                    this.max = d;
                }
                if (dc == 3) {
                    this.units.scales = d;
                }
                if (dc == 4) {
                    this.units.scaleu = d;
                }
                ++dc;
            }
            if (!(a instanceof String)) continue;
            String s = a.toString();
            if (sc == 0) {
                this.name = s;
            }
            if (sc >= 1) {
                this.units = new units(s);
            }
            ++sc;
        }
        if (this.units != null) {
            this.units.checkunitcancel();
            this.units.checkunitfac(this.max - this.min);
        }
        this.register();
        this.addDocAction();
    }

    public boolean isdefault() {
        if (this.type == Type.menu) {
            return this.chosen == this.defchosen;
        }
        if (this.type == Type.option) {
            return this.flag == this.defflag;
        }
        if (this.type == Type.value) {
            return this.val == this.defval;
        }
        return true;
    }

    public String save() {
        return this.getFullName() + "\t" + (this.type == Type.menu ? this.getchosenindex() + "\t" + this.chosen : (this.type == Type.option ? Boolean.valueOf(this.flag) : (this.type == Type.value ? Double.valueOf(this.val) : ""))) + "\n";
    }

    public void load(String s) {
        if (this.type == Type.menu) {
            this.choose(Integer.parseInt(s));
        }
        if (this.type == Type.option) {
            this.flag = s.equals("true");
        }
        if (this.type == Type.value) {
            this.val = Double.valueOf(s);
        }
        this.changed = true;
    }

    public void reset() {
        if (this.type == Type.menu && this.chosen != this.defchosen) {
            this.chosen = this.defchosen;
            this.changed = true;
        }
        if (this.type == Type.option && this.flag != this.defflag) {
            this.flag = this.defflag;
            this.changed = true;
        }
        if (this.type == Type.value && this.val != this.defval) {
            this.val = this.defval;
            this.changed = true;
        }
        if (this.type == Type.trigger) {
            this.flag = this.defflag;
        }
    }

    public void choose(int i) {
        if (this.type == Type.menu) {
            this.chosen = this.menulist[i];
        }
    }

    public void choose(Object c) {
        if (c.equals("next")) {
            this.choose((this.getchosenindex() + 1) % this.numitems);
            return;
        }
        if (c.equals("prev")) {
            this.choose((this.numitems + this.getchosenindex() - 1) % this.numitems);
            return;
        }
        for (T o : this.menulist) {
            if (!c.equals(o)) continue;
            this.chosen = o;
        }
    }

    public void setval(double val) {
        this.val = val;
    }

    public void setflag(boolean b) {
        this.flag = b;
    }

    public void set(double d) {
        loop.changeinteractions = false;
        this.val = d;
        if (this.val < this.min) {
            this.val = this.min;
        } else if (this.val > this.max) {
            this.val = this.max;
        }
        this.doscript();
    }

    public void set(boolean b) {
        this.flag = b;
        this.doscript();
    }

    public void set(T o) {
        this.choose(o);
        this.doscript();
    }

    public void set(int i) {
        if (this.type == Type.value) {
            this.set((double)i);
        } else {
            this.choose(i);
            this.doscript();
        }
    }

    public void doscript() {
        this.respond(!calcscript.delayloop());
    }

    public void respond(boolean domodloop) {
        if (reportchange) {
            System.out.println(this.getFullName() + " " + this.getstringval());
        }
        this.changed = true;
        if (domodloop) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    loop.go();
                }
            });
        }
    }

    public void doscript(String s) {
        if (this.type == Type.option) {
            this.flag = !s.equals("false") && !s.equals("f") && !s.equals("F") && !s.equals("off") && !s.equals("dis") && !s.equals("disabled");
        }
        if (this.type == Type.menu) {
            this.choose(s);
        }
        if (this.type == Type.value) {
            this.setval(Double.valueOf(s));
        }
        this.doscript();
    }

    public void precalc() {
    }

    @Override
    public boolean checkenabled() {
        return register.checkneededforplotexcept(this, treeMaker.class);
    }

    public T getchosen() {
        return this.chosen;
    }

    public String getstringval() {
        return "" + (this.type == Type.option ? "" + this.flag : (this.type == Type.menu ? this.chosen.toString() : (this.type == Type.value ? "" + this.units.round(this.val) : "")));
    }

    public double getval() {
        return this.val;
    }

    public double getdef() {
        return this.defval;
    }

    public double getfrac() {
        return this.val / this.defval;
    }

    public boolean istrue() {
        return this.flag;
    }

    public float min() {
        return (float)this.min;
    }

    public float max() {
        return (float)this.max;
    }

    public float range() {
        return (float)(this.max - this.min);
    }

    public boolean isnotdefault() {
        if (this.type == Type.menu) {
            return this.chosen != this.defchosen;
        }
        if (this.type == Type.value) {
            return this.val != this.defval;
        }
        if (this.type == Type.option) {
            return this.flag != this.defflag;
        }
        return false;
    }

    public String chosenname() {
        return this.chosen.toString();
    }

    public String getname(int i) {
        return this.menulist[i].toString();
    }

    public String getname(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        try {
            return o.getClass().getField("name").get(o).toString();
        }
        catch (Exception e) {
            try {
                return o.getClass().getMethod("getName", new Class[0]).invoke(o, new Object[0]).toString();
            }
            catch (Exception exception) {
                if (o instanceof interacob) {
                    return ((interacob)o).name;
                }
                if (o instanceof Enum) {
                    return ((Enum)o).name();
                }
                return o.getClass().getSimpleName();
            }
        }
    }

    public int getchosenindex() {
        int i = 0;
        for (int j = 0; j < this.menulist.length; ++j) {
            if (!this.chosen.equals(this.menulist[j])) continue;
            i = j;
        }
        return i;
    }

    public String getinfo() {
        return this.getLabel() + this.getstate() + this.addunits();
    }

    public String addunits() {
        return this.type == Type.value ? " \t\t" + labman.getShort(this.units.units) : "";
    }

    public String getstate() {
        block7: {
            block6: {
                if (this.type == Type.menu) {
                    return " \t\t" + labman.getTitle(this.chosen.toString()) + " (def=" + labman.getTitle(this.defchosen.toString()) + ") \n";
                }
                if (this.type == Type.option) {
                    return " \t\t: " + (this.flag ? labman.getTitle("ena") : labman.getTitle("dis")) + " (def=" + (this.defflag ? labman.getTitle("ena") : labman.getTitle("dis")) + ") \n";
                }
                if (this.type == Type.value) {
                    return " val=" + this.units.round(this.val, this.dp) + " (def=" + this.units.round(this.defval, this.dp) + ") \n";
                }
                if (this.type == Type.Xscale) break block6;
                if (this.type != Type.Yscale) break block7;
            }
            return (Object)((Object)this.type) + ": " + this.units.round(this.min) + " - " + this.units.round(this.max) + " " + labman.getShort(this.units.units) + labman.getTitleIfDifferent(this.units.units);
        }
        return "";
    }

    @Override
    public String docSummary() {
        return this.hashcolor() + (this.checkenabled() ? "" : " //(inactive)// ") + autodoc.link(this) + "</font> " + "\u00a3%" + this.name + "<br>";
    }

    @Override
    public String getExtraDoc() {
        block3: {
            block2: {
                if (this.type == Type.Xscale) break block2;
                if (this.type != Type.Yscale) break block3;
            }
            return this.getinfo();
        }
        return this.getInput() + this.moreinfo() + "<hr>" + this.docInteracs() + autodoc.javacode(this);
    }

    public String getInput() {
        String pi = " <br>%%\u00a4adju \u00a3\u00a7paraminterac %%<br>";
        if (this.type == Type.option) {
            return " <input type=checkbox " + (this.flag ? "checked" : "") + " > " + pi;
        }
        if (this.type == Type.value) {
            return " <input type=text value=" + this.units.round(this.val, this.dp) + " > " + (this.units != null ? labman.getTitle(this.units.units) : "") + (this.isnotdefault() ? " (<i>\u00a3`default : " + this.units.round(this.defval, this.dp) + "</i>) " : "") + pi;
        }
        if (this.type == Type.menu) {
            String info = " <select>";
            for (int i = 0; i < this.numitems; ++i) {
                info = info + "<option " + this.getname(i) + (i == this.getchosenindex() ? " selected" : "") + " >" + labman.getTitle(this.getname(i));
            }
            return info + "</select>" + pi;
        }
        if (this.type == Type.trigger) {
            return " <input type=button value='" + labman.getShort(this.name) + "' > " + pi;
        }
        return "";
    }

    public String moreinfo() {
        if (this.type == Type.menu) {
            String info2 = "";
            for (int i = 0; i < this.numitems; ++i) {
                info2 = info2 + "<li>" + autodoc.link(this.getname(i)) + " \u00a3%" + this.getname(i);
            }
            return "<hr> \u00a3`moreinfo <ul>" + info2 + "</ul>";
        }
        if (this.type == Type.value && this.pair != null) {
            return "<hr>" + this.pair.getExtraDoc();
        }
        return "";
    }

    @Override
    public JComponent getComponent(Object ... args) {
        if (this.type == Type.menu) {
            return new paramMenu(this, args);
        }
        if (this.type == Type.value) {
            return new paramValueChooser(this, args);
        }
        if (this.type == Type.option) {
            return new paramOption(this, args);
        }
        return super.getComponent(new Object[0]);
    }

    public JMenuItem getMenuItem() {
        if (this.type == Type.menu) {
            JMenu pm = new JMenu(this.getLabel());
            ButtonGroup group = new ButtonGroup();
            for (final T o : this.menulist) {
                JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(new AbstractAction(labman.getTitle(this.getname(o))){

                    public void actionPerformed(ActionEvent e) {
                        param.this.set(o);
                    }
                });
                group.add(rbmi);
                pm.add(rbmi);
                if (o != this.chosen) continue;
                rbmi.setSelected(true);
            }
            return pm;
        }
        if (this.type == Type.option) {
            return new cb(this);
        }
        if (this.type == Type.value) {
            JMenuItem jm = new JMenuItem();
            JComponent c = this.getComponent("menu");
            jm.setLayout(null);
            jm.setArmed(false);
            jm.setEnabled(true);
            jm.add(c);
            c.revalidate();
            c.setLocation(0, 0);
            c.setSize(c.getPreferredSize());
            jm.setPreferredSize(c.getPreferredSize());
            return jm;
        }
        return null;
    }

    class cb
    extends JCheckBoxMenuItem
    implements plotlink,
    ChangeListener {
        public cb(param p) {
            this.setText(p.getLabel());
            this.setSelected(param.this.istrue());
            this.setForeground(param.this.getColor());
            this.addChangeListener(this);
            register.addlink(this, p);
        }

        public void doplot() {
            if (param.this.changed) {
                loop.golater();
            }
            this.setSelected(param.this.istrue());
            this.setToolTipText(param.this.getinfo());
        }

        public void stateChanged(ChangeEvent e) {
            if (param.this.istrue() != this.isSelected()) {
                param.this.set(this.isSelected());
            }
            this.setText(param.this.getLabel());
            this.setToolTipText(param.this.getinfo());
        }

        public void addNotify() {
            super.addNotify();
            this.doplot();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        menu,
        option,
        value,
        Xscale,
        Yscale,
        trigger;

    }
}

