/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import jcm.core.complexity;
import jcm.core.hasinfo;
import jcm.core.module;
import jcm.core.world;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.contextMenu;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.menuFiller;
import jcm.gui.nav.showpan;
import jcm.gui.nav.treeMaker;

public class infob
implements hasinfo,
menuFiller {
    public String name = this.getClass().getSimpleName();
    public infob owner = this;
    public complexity mycomplexity = complexity.simplest;
    public Color color = infob.rcol();
    public Set obs;
    public List<Action> actions;
    public double priority = 1.0;
    static Object[][] setupinfo = new Object[][]{{"mod", 2.0}, {"obj", 6.0, colfont.dkblue}, {"soc", 5.0, colfont.brown}, {"carbon", 4.0, colfont.black}, {"ogas", 3.0, colfont.dkgreen}, {"cli", 2.0, colfont.dkred}, {"reg", 1.0, colfont.dkpurple}, {"socreg", 2.0}, {"controller", 2.0}, {"costs", 0.8}, {"optimisation", 0.8}, {"othgasemit", 2.0}, {"carboncycle", 2.0}, {"carbonatechemistry", 0.8}, {"radfor", 2.5}, {"glotemp", 2.0}, {"udebclimod", 1.5}};
    public Action docaction;
    public Action treeaction;

    public void checkinfo() {
        for (Object[] oo : setupinfo) {
            if (!infob.removepackagename(this.name).equals((String)oo[0])) continue;
            this.priority = (Double)oo[1];
            if (oo.length == 3) {
                this.color = (Color)oo[2];
            }
            return;
        }
    }

    public infob() {
        this.color = infob.rcol();
    }

    public infob(Object ... args) {
        this.color = null;
        for (Object o : args) {
            if (o instanceof infob) {
                this.owner = (infob)o;
                if (this.color == null) {
                    this.color = infob.rcol(this.owner.color);
                }
            }
            if (o instanceof String) {
                this.name = (String)o;
                this.checkinfo();
            }
            if (o instanceof Color) {
                this.color = (Color)o;
            }
            if (!(o instanceof Number)) continue;
            this.priority = ((Number)o).floatValue();
        }
        if (this.color == null) {
            this.color = infob.rcol();
        }
    }

    public void addDocAction() {
        if (this.docaction == null) {
            this.docaction = showpan.pan("Doc", docview.class, this.name);
        }
        this.addAction(this.docaction);
    }

    public void addTreeAction() {
        if (this.treeaction == null) {
            this.treeaction = showpan.pan("Tree", treeMaker.class, "[" + this + "]");
        }
        this.addAction(this.treeaction);
    }

    void mincomplexity() {
        this.mincomplexity(this.getObs());
    }

    void mincomplexity(Collection obs) {
        if (obs != null) {
            this.mycomplexity = complexity.experimental;
            for (Object o : obs) {
                if (!(o instanceof hasinfo)) continue;
                this.mycomplexity = ((hasinfo)o).getComplexity().compareTo(this.mycomplexity) < 0 ? ((hasinfo)o).getComplexity() : this.mycomplexity;
            }
        }
    }

    public complexity getComplexity() {
        return this.mycomplexity;
    }

    public boolean checkcomplexity() {
        return complexity.check(this.getComplexity());
    }

    public boolean checkenabled() {
        return true;
    }

    public world getworld() {
        if (this.owner instanceof world) {
            return (world)this.owner;
        }
        if (this.owner == this) {
            return null;
        }
        return this.owner.getworld();
    }

    public module getmodule() {
        if (this.owner instanceof module) {
            return (module)this.owner;
        }
        if (this.owner == this) {
            return null;
        }
        return this.owner.getmodule();
    }

    public hasinfo getOwner() {
        return this.owner;
    }

    public Set getObs() {
        return this.obs;
    }

    public List getEnabledObs(boolean checkcomplexity, boolean checkenabled) {
        ArrayList eo = new ArrayList();
        if (this.obs == null) {
            return null;
        }
        for (Object o : this.obs) {
            if (o instanceof infob && (checkcomplexity && !((infob)o).checkcomplexity() || checkenabled && !((infob)o).checkenabled())) continue;
            eo.add(o);
        }
        if (eo.size() > 0) {
            return eo;
        }
        return null;
    }

    public void addOb(Object h) {
        if (this.getObs() == null) {
            this.obs = new TreeSet(new Comparator(){

                public int compare(Object a, Object b) {
                    if (a instanceof infob && b instanceof infob) {
                        int i = (int)Math.signum(((infob)b).priority - ((infob)a).priority);
                        if (i == 0) {
                            i = ((infob)a).name.compareTo(((infob)b).name);
                        }
                        return i;
                    }
                    return a.getClass().getName().compareTo(b.getClass().getName());
                }
            });
        }
        this.getObs().add(h);
    }

    public void removeOb(Object h) {
        this.getObs().remove(h);
    }

    public void addAction(Action a) {
        if (this.actions == null) {
            this.actions = new LinkedList<Action>();
        }
        this.actions.add(a);
    }

    public Object find(String s) {
        return this.find(this, s);
    }

    public Object find(Object orig, String s) {
        if (this.obs != null) {
            for (Object o : this.obs) {
                if (!o.toString().equals(s)) continue;
                return o;
            }
            for (Object o : this.obs) {
                Object oo;
                if (!(o instanceof infob) || o == orig || (oo = ((infob)o).find(orig, s)) == null) continue;
                return oo;
            }
        }
        return null;
    }

    public Color getColor() {
        return this.color;
    }

    public String hashcolor() {
        return infob.hashcolor(this.getColor());
    }

    public static String hashcolor(Color c) {
        return "<font color=#" + infob.hex2(c.getRed()) + infob.hex2(c.getGreen()) + infob.hex2(c.getBlue()) + " >";
    }

    public static String hex2(int x) {
        return (x < 16 ? "0" : "") + Integer.toHexString(x);
    }

    public static Color rcol() {
        return new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random()));
    }

    public static Color rcol(Color b) {
        if (b == null) {
            return infob.rcol();
        }
        return new Color((int)(127.0 * Math.random()) + b.getRed() / 2, (int)(127.0 * Math.random()) + b.getGreen() / 2, (int)(127.0 * Math.random()) + b.getBlue() / 2);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return (this.owner != this ? this.owner.getFullName() + "&" : "") + this.name;
    }

    public static String removepackagename(String s) {
        int i = s.indexOf(".");
        return i > 0 ? infob.removepackagename(s.substring(i + 1)) : s;
    }

    public String type() {
        return this.getClass().getSimpleName();
    }

    public String getLabel() {
        return labman.getShort(this.name);
    }

    public String getTitle() {
        return labman.getTitle(this.name);
    }

    public String getLongTitle() {
        return labman.getTitle(this.getFullName());
    }

    public String getExtraDoc() {
        return this.docPackageInfo();
    }

    public String getSpecificDoc(Object ... args) {
        return "<p><b>!specific doc request " + args[0] + " for " + this.name + " no longer implemented!</b><p> ";
    }

    public String docSummary() {
        try {
            this.getClass();
            Class.forName(this.name);
            String n2 = infob.removepackagename(this.name);
            return autodoc.link(n2) + "</font> " + "\u00a3%" + n2 + "<br>";
        }
        catch (ClassNotFoundException e) {
            return autodoc.link(this) + "</font> " + "\u00a3%" + this.name + "<br>";
        }
    }

    public String docPackageInfo() {
        String s = "  ==\u00a3`packageinfo ==";
        List c = this.getEnabledObs(true, false);
        if (c != null) {
            s = s + "<ul> ";
            for (Object o : c) {
                s = s + (o instanceof infob ? ((infob)o).docSummary() : o);
            }
        }
        return s + "</ul><hr>" + this.docOwner() + "%%\u00a4cogs package name=" + this.name + "%%";
    }

    public String docOwner() {
        return this.owner != this ? "<nobr>%%\u00a4cogs \u00a3`memberof  " + autodoc.link(this.owner.name) + "%%</nobr><br>" : "";
    }

    public JComponent getComponent(Object ... args) {
        Box b = Box.createHorizontalBox();
        new contextMenu(b, this);
        JLabel jl = new JLabel(this.getLabel(), this.getIcon(), 2);
        jl.setForeground(this.getColor());
        b.add(jl);
        b.addMouseListener(showpan.moulist);
        b.addMouseMotionListener(showpan.moulist);
        showpan.moulist.cimap.put(b, this);
        return b;
    }

    public void fillMenu(JPopupMenu popup) {
        if (this.actions != null) {
            for (Action a : this.actions) {
                if (popup.getInvoker() instanceof JTree && (a == this.treeaction || treeMaker.helpmode.istrue() && a == this.docaction)) continue;
                popup.add(a);
            }
        }
    }

    public Icon getIcon() {
        return iconFinder.findIcon(this);
    }
}

